/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.file.impl;

import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.file.AsyncFile;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.file.OpenOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.file.impl.AsyncFileImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.file.impl.FileSystemImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.ContextInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;

public class WindowsFileSystem
extends FileSystemImpl {
    private static final Logger log = LoggerFactory.getLogger(WindowsFileSystem.class);

    public WindowsFileSystem(VertxInternal vertx) {
        super(vertx);
    }

    private static void logInternal(String perms) {
        if (perms != null && log.isDebugEnabled()) {
            log.debug("You are running on Windows and POSIX style file permissions are not supported");
        }
    }

    @Override
    protected FileSystemImpl.BlockingAction<Void> chmodInternal(String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(perms);
        WindowsFileSystem.logInternal(perms);
        WindowsFileSystem.logInternal(dirPerms);
        if (log.isDebugEnabled()) {
            log.debug("You are running on Windows and POSIX style file permissions are not supported!");
        }
        return new FileSystemImpl.BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                return null;
            }
        };
    }

    @Override
    protected FileSystemImpl.BlockingAction<Void> mkdirInternal(String path, String perms, boolean createParents, Handler<AsyncResult<Void>> handler) {
        WindowsFileSystem.logInternal(perms);
        return super.mkdirInternal(path, null, createParents, handler);
    }

    @Override
    protected AsyncFile doOpen(String path, OpenOptions options, ContextInternal context) {
        WindowsFileSystem.logInternal(options.getPerms());
        return new AsyncFileImpl(this.vertx, path, options, context);
    }

    @Override
    protected FileSystemImpl.BlockingAction<Void> createFileInternal(String p, String perms, Handler<AsyncResult<Void>> handler) {
        WindowsFileSystem.logInternal(perms);
        return super.createFileInternal(p, null, handler);
    }

    @Override
    protected FileSystemImpl.BlockingAction<Void> chownInternal(String path, String user, String group, Handler<AsyncResult<Void>> handler) {
        if (group != null && log.isDebugEnabled()) {
            log.debug("You are running on Windows and POSIX style file ownership is not supported");
        }
        return super.chownInternal(path, user, group, handler);
    }
}

