/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http;

import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.CacheReturn;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.Fluent;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.GenIgnore;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.Nullable;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.VertxGen;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.MultiMap;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.Cookie;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpConnection;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpFrame;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpMethod;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerFileUpload;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerResponse;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpVersion;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.ServerWebSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.StreamPriority;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.streams.ReadStream;

@VertxGen
public interface HttpServerRequest
extends ReadStream<Buffer> {
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> var1);

    public HttpServerRequest handler(Handler<Buffer> var1);

    public HttpServerRequest pause();

    public HttpServerRequest resume();

    public HttpServerRequest fetch(long var1);

    public HttpServerRequest endHandler(Handler<Void> var1);

    public HttpVersion version();

    public HttpMethod method();

    public String rawMethod();

    public boolean isSSL();

    public @Nullable String scheme();

    public String uri();

    public @Nullable String path();

    public @Nullable String query();

    public @Nullable String host();

    public long bytesRead();

    @CacheReturn
    public HttpServerResponse response();

    @CacheReturn
    public MultiMap headers();

    public @Nullable String getHeader(String var1);

    @GenIgnore(value={"permitted-type"})
    public String getHeader(CharSequence var1);

    @CacheReturn
    public MultiMap params();

    public @Nullable String getParam(String var1);

    @CacheReturn
    public SocketAddress remoteAddress();

    @CacheReturn
    public SocketAddress localAddress();

    @GenIgnore(value={"permitted-type"})
    public SSLSession sslSession();

    @GenIgnore
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException;

    public String absoluteURI();

    @Fluent
    default public HttpServerRequest bodyHandler(@Nullable Handler<Buffer> bodyHandler) {
        if (bodyHandler != null) {
            Buffer body = Buffer.buffer();
            this.handler(body::appendBuffer);
            this.endHandler(v -> bodyHandler.handle(body));
        }
        return this;
    }

    @Deprecated
    @CacheReturn
    public NetSocket netSocket();

    default public void toNetSocket(Handler<AsyncResult<NetSocket>> handler) {
        Future<Object> fut;
        if (this.method() != HttpMethod.CONNECT) {
            fut = Future.failedFuture("");
        } else {
            try {
                fut = Future.succeededFuture(this.netSocket());
            }
            catch (Exception e) {
                fut = Future.failedFuture(e);
            }
        }
        handler.handle(fut);
    }

    @Fluent
    public HttpServerRequest setExpectMultipart(boolean var1);

    public boolean isExpectMultipart();

    @Fluent
    public HttpServerRequest uploadHandler(@Nullable Handler<HttpServerFileUpload> var1);

    @CacheReturn
    public MultiMap formAttributes();

    public @Nullable String getFormAttribute(String var1);

    @CacheReturn
    default public int streamId() {
        return -1;
    }

    @Deprecated
    public ServerWebSocket upgrade();

    default public void toWebSocket(Handler<AsyncResult<ServerWebSocket>> handler) {
        Future<ServerWebSocket> fut;
        try {
            fut = Future.succeededFuture(this.upgrade());
        }
        catch (Exception e) {
            fut = Future.failedFuture(e);
        }
        handler.handle(fut);
    }

    public boolean isEnded();

    @Fluent
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> var1);

    @CacheReturn
    public HttpConnection connection();

    default public StreamPriority streamPriority() {
        return null;
    }

    @Fluent
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> var1);

    public @Nullable Cookie getCookie(String var1);

    public int cookieCount();

    @GenIgnore
    public Map<String, Cookie> cookieMap();
}

