/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelFuture;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPipeline;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPromise;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.FileRegion;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.DecoderResult;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.TooLongFrameException;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.DefaultFullHttpResponse;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.DefaultHttpRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.FullHttpRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpContent;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpHeaderNames;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpObject;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpResponseStatus;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.LastHttpContent;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.WebSocketFrame;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.WebSocketVersion;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.stream.ChunkedFile;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.ReferenceCountUtil;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.GenericFutureListener;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpHeaders;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpMethod;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpVersion;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.ServerWebSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.Http1xConnectionBase;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpChunkContentCompressor;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpServerConnection;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpServerRequestImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpUtils;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.ServerWebSocketImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.ContextInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.NetSocketImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.SSLHelper;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.VertxHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.HttpServerMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.Metrics;

public class Http1xServerConnection
extends Http1xConnectionBase<ServerWebSocketImpl>
implements HttpServerConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerConnection.class);
    private final String serverOrigin;
    private final SSLHelper sslHelper;
    private boolean requestFailed;
    private long bytesRead;
    private long bytesWritten;
    private HttpServerRequestImpl requestInProgress;
    private HttpServerRequestImpl responseInProgress;
    private boolean channelPaused;
    private Handler<HttpServerRequest> requestHandler;
    final HttpServerMetrics metrics;
    final boolean handle100ContinueAutomatically;
    final HttpServerOptions options;

    public Http1xServerConnection(VertxInternal vertx, SSLHelper sslHelper, HttpServerOptions options, ChannelHandlerContext channel, ContextInternal context, String serverOrigin, HttpServerMetrics metrics) {
        super(vertx, channel, context);
        this.serverOrigin = serverOrigin;
        this.options = options;
        this.sslHelper = sslHelper;
        this.metrics = metrics;
        this.handle100ContinueAutomatically = options.isHandle100ContinueAutomatically();
    }

    @Override
    public HttpServerConnection handler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Object msg) {
        if (msg instanceof HttpRequest) {
            DefaultHttpRequest request = (DefaultHttpRequest)msg;
            if (request.decoderResult() != DecoderResult.SUCCESS) {
                this.handleError(request);
                return;
            }
            HttpServerRequestImpl req = new HttpServerRequestImpl(this, request);
            Http1xServerConnection http1xServerConnection = this;
            synchronized (http1xServerConnection) {
                this.requestInProgress = req;
                if (this.responseInProgress != null) {
                    req.pause();
                    this.responseInProgress.enqueue(req);
                    return;
                }
                this.responseInProgress = this.requestInProgress;
                req.handleBegin();
            }
            this.requestHandler.handle(req);
        } else if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.handleEnd();
        } else if (msg instanceof HttpContent) {
            this.handleContent(msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleContent(Object msg) {
        HttpServerRequestImpl request;
        HttpContent content = (HttpContent)msg;
        if (content.decoderResult() != DecoderResult.SUCCESS) {
            this.handleError(content);
            return;
        }
        Buffer buffer = Buffer.buffer(VertxHandler.safeBuffer(content.content(), this.chctx.alloc()));
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            if (Metrics.METRICS_ENABLED) {
                this.reportBytesRead(buffer);
            }
            request = this.requestInProgress;
        }
        request.handleContent(buffer);
        if (content instanceof LastHttpContent) {
            this.handleEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEnd() {
        HttpServerRequestImpl request;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            if (Metrics.METRICS_ENABLED) {
                this.reportRequestComplete();
            }
            request = this.requestInProgress;
            this.requestInProgress = null;
        }
        request.handleEnd();
    }

    synchronized void responseComplete() {
        if (Metrics.METRICS_ENABLED) {
            this.reportResponseComplete();
        }
        HttpServerRequestImpl request = this.responseInProgress;
        this.responseInProgress = null;
        HttpServerRequestImpl next = request.next();
        if (next != null) {
            this.handleNext(next);
        }
    }

    private void handleNext(HttpServerRequestImpl next) {
        this.responseInProgress = next;
        next.handleBegin();
        this.context.runOnContext(v -> {
            next.resume();
            this.requestHandler.handle(next);
        });
    }

    @Override
    public void doPause() {
        if (!this.channelPaused) {
            this.channelPaused = true;
            super.doPause();
        }
    }

    @Override
    public void doResume() {
        if (this.channelPaused) {
            this.channelPaused = false;
            super.doResume();
        }
    }

    private void reportBytesRead(Buffer buffer) {
        if (this.metrics != null) {
            this.bytesRead += (long)buffer.length();
        }
    }

    private void reportBytesWritten(Object msg) {
        if (this.metrics != null) {
            long bytes = this.getBytes(msg);
            if (bytes == -1L) {
                log.warn("Metrics could not be updated to include bytes written because of unknown object " + msg.getClass() + " being written.");
            } else {
                this.bytesWritten += bytes;
            }
        }
    }

    private void reportRequestComplete() {
        if (this.metrics != null) {
            this.reportBytesRead(this.bytesRead);
            this.bytesRead = 0L;
        }
    }

    private void reportResponseComplete() {
        if (this.metrics != null) {
            this.reportBytesWritten(this.bytesWritten);
            if (this.requestFailed) {
                this.metrics.requestReset(this.responseInProgress.metric());
                this.requestFailed = false;
            } else {
                this.metrics.responseEnd(this.responseInProgress.metric(), this.responseInProgress.response());
            }
            this.bytesWritten = 0L;
        }
    }

    String getServerOrigin() {
        return this.serverOrigin;
    }

    Vertx vertx() {
        return this.vertx;
    }

    @Override
    public void writeToChannel(Object msg, ChannelPromise promise) {
        if (Metrics.METRICS_ENABLED) {
            this.reportBytesWritten(msg);
        }
        super.writeToChannel(msg, promise);
    }

    ServerWebSocketImpl createWebSocket(HttpServerRequestImpl request) {
        if (this.ws != null) {
            return (ServerWebSocketImpl)this.ws;
        }
        if (!(request.nettyRequest() instanceof FullHttpRequest)) {
            throw new IllegalStateException();
        }
        WebSocketServerHandshaker handshaker = this.createHandshaker(request);
        if (handshaker == null) {
            return null;
        }
        this.ws = new ServerWebSocketImpl(this, handshaker.version() != WebSocketVersion.V00, request, handshaker, this.options.getMaxWebsocketFrameSize(), this.options.getMaxWebsocketMessageSize());
        if (Metrics.METRICS_ENABLED && this.metrics != null) {
            ((ServerWebSocketImpl)this.ws).setMetric(this.metrics.connected(this.metric(), request.metric(), (ServerWebSocket)((Object)this.ws)));
        }
        return (ServerWebSocketImpl)this.ws;
    }

    private WebSocketServerHandshaker createHandshaker(HttpServerRequestImpl request) {
        String wsURL;
        Channel ch = this.channel();
        String connectionHeader = request.getHeader(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("\"Connection\" header must be \"Upgrade\".");
            return null;
        }
        if (request.method() != HttpMethod.GET) {
            request.response().setStatusCode(HttpResponseStatus.METHOD_NOT_ALLOWED.code()).end();
            return null;
        }
        try {
            wsURL = HttpUtils.getWebSocketLocation(request, this.isSsl());
        }
        catch (Exception e) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Invalid request URI");
            return null;
        }
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(wsURL, this.options.getWebsocketSubProtocols(), this.options.getPerMessageWebsocketCompressionSupported() || this.options.getPerFrameWebsocketCompressionSupported(), this.options.getMaxWebsocketFrameSize(), this.options.isAcceptUnmaskedFrames());
        WebSocketServerHandshaker shake = factory.newHandshaker(request.nettyRequest());
        if (shake == null) {
            request.response().putHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (CharSequence)WebSocketVersion.V13.toHttpHeaderValue()).setStatusCode(HttpResponseStatus.UPGRADE_REQUIRED.code()).end();
        }
        return shake;
    }

    NetSocket createNetSocket() {
        final HashMap<Channel, 1> connectionMap = new HashMap<Channel, 1>(1);
        NetSocketImpl socket = new NetSocketImpl(this.vertx, this.chctx, this.context, this.sslHelper, this.metrics){

            @Override
            protected void handleClosed() {
                if (Http1xServerConnection.this.metrics != null) {
                    Http1xServerConnection.this.metrics.responseEnd(Http1xServerConnection.this.responseInProgress.metric(), Http1xServerConnection.this.responseInProgress.response());
                }
                connectionMap.remove(this.chctx.channel());
                super.handleClosed();
            }

            @Override
            public synchronized void handleMessage(Object msg) {
                if (msg instanceof HttpContent) {
                    ReferenceCountUtil.release(msg);
                    return;
                }
                super.handleMessage(msg);
            }
        };
        socket.metric(this.metric());
        connectionMap.put(this.chctx.channel(), socket);
        this.flush();
        ChannelPipeline pipeline = this.chctx.pipeline();
        HttpChunkContentCompressor compressor = pipeline.get(HttpChunkContentCompressor.class);
        if (compressor != null) {
            pipeline.remove(compressor);
        }
        pipeline.remove("httpDecoder");
        if (pipeline.get("chunkedWriter") != null) {
            pipeline.remove("chunkedWriter");
        }
        this.chctx.pipeline().replace("handler", "handler", VertxHandler.create(socket));
        this.chctx.pipeline().remove("httpEncoder");
        return socket;
    }

    @Override
    public synchronized void handleInterestedOpsChanged() {
        if (!this.isNotWritable()) {
            if (this.responseInProgress != null) {
                this.responseInProgress.response().handleDrained();
            } else if (this.ws != null) {
                ((ServerWebSocketImpl)this.ws).handleDrained();
            }
        }
    }

    void write100Continue() {
        this.chctx.writeAndFlush(new DefaultFullHttpResponse(ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        HttpServerRequestImpl responseInProgress;
        HttpServerRequestImpl requestInProgress;
        ServerWebSocketImpl ws;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = (ServerWebSocketImpl)this.ws;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
            if (Metrics.METRICS_ENABLED && this.metrics != null && ws != null) {
                this.metrics.disconnected(ws.getMetric());
                ws.setMetric(null);
            }
        }
        if (requestInProgress != null) {
            requestInProgress.handleException(CLOSED_EXCEPTION);
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.handleException(CLOSED_EXCEPTION);
        }
        if (ws != null) {
            ws.handleClosed();
        }
        super.handleClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleException(Throwable t) {
        HttpServerRequestImpl responseInProgress;
        HttpServerRequestImpl requestInProgress;
        ServerWebSocketImpl ws;
        super.handleException(t);
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = (ServerWebSocketImpl)this.ws;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
            if (Metrics.METRICS_ENABLED && this.metrics != null) {
                this.requestFailed = true;
            }
        }
        if (requestInProgress != null) {
            requestInProgress.handleException(t);
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.handleException(t);
        }
        if (ws != null) {
            ws.handleException(t);
        }
    }

    @Override
    protected void addFuture(Handler<AsyncResult<Void>> completionHandler, ChannelFuture future) {
        super.addFuture(completionHandler, future);
    }

    @Override
    protected boolean supportsFileRegion() {
        return super.supportsFileRegion() && this.chctx.pipeline().get(HttpChunkContentCompressor.class) == null;
    }

    @Override
    protected ChannelFuture sendFile(RandomAccessFile file, long offset, long length) throws IOException {
        return super.sendFile(file, offset, length);
    }

    private void handleError(HttpObject obj) {
        DecoderResult result = obj.decoderResult();
        Throwable cause = result.cause();
        if (cause instanceof TooLongFrameException) {
            String causeMsg = cause.getMessage();
            ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpVersion version = obj instanceof HttpRequest ? ((HttpRequest)obj).protocolVersion() : (this.requestInProgress != null ? (this.requestInProgress.version() == HttpVersion.HTTP_1_0 ? ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpVersion.HTTP_1_0 : ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpVersion.HTTP_1_1) : ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpVersion.HTTP_1_1);
            HttpResponseStatus status = causeMsg.startsWith("An HTTP line is larger than") ? HttpResponseStatus.REQUEST_URI_TOO_LONG : (causeMsg.startsWith("HTTP header is larger than") ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST);
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(version, status);
            ChannelPromise fut = this.chctx.newPromise();
            this.writeToChannel(resp, fut);
            fut.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)res -> this.fail(result.cause())));
        } else {
            this.fail(result.cause());
        }
    }

    private long getBytes(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Buffer) {
            return ((Buffer)obj).length();
        }
        if (obj instanceof ByteBuf) {
            return ((ByteBuf)obj).readableBytes();
        }
        if (obj instanceof HttpContent) {
            return ((HttpContent)obj).content().readableBytes();
        }
        if (obj instanceof WebSocketFrame) {
            return ((WebSocketFrame)obj).content().readableBytes();
        }
        if (obj instanceof FileRegion) {
            return ((FileRegion)obj).count();
        }
        if (obj instanceof ChunkedFile) {
            ChunkedFile file = (ChunkedFile)obj;
            return file.endOffset() - file.startOffset();
        }
        return -1L;
    }
}

