/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBufAllocator;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.Unpooled;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPromise;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Connection;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Exception;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Flags;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2FrameListener;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Headers;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Stream;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.collection.IntObjectHashMap;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.collection.IntObjectMap;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.GenericFutureListener;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.Nullable;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.VertxException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.GoAway;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.Http2Settings;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpConnection;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.StreamPriority;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpUtils;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.VertxHttp2NetSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.VertxHttp2Stream;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.ContextInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.ConnectionBase;

abstract class Http2ConnectionBase
extends ConnectionBase
implements Http2FrameListener,
HttpConnection {
    protected final IntObjectMap<VertxHttp2Stream> streams = new IntObjectHashMap<VertxHttp2Stream>();
    protected final ChannelHandlerContext handlerContext;
    protected final VertxHttp2ConnectionHandler handler;
    private boolean shutdown;
    private Handler<Http2Settings> remoteSettingsHandler;
    private final ArrayDeque<Handler<Void>> updateSettingsHandlers = new ArrayDeque();
    private final ArrayDeque<Handler<AsyncResult<Buffer>>> pongHandlers = new ArrayDeque();
    private ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Settings localSettings = new ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Settings();
    private ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Settings remoteSettings;
    private Handler<GoAway> goAwayHandler;
    private Handler<Void> shutdownHandler;
    private Handler<Buffer> pingHandler;
    private boolean goneAway;
    private int windowSize;
    private long maxConcurrentStreams;

    static ByteBuf safeBuffer(ByteBuf buf, ByteBufAllocator allocator) {
        ByteBuf buffer = allocator.heapBuffer(buf.readableBytes());
        buffer.writeBytes(buf);
        return buffer;
    }

    public Http2ConnectionBase(ContextInternal context, VertxHttp2ConnectionHandler handler) {
        super(context.owner(), handler.context(), context);
        this.handler = handler;
        this.handlerContext = this.chctx;
        this.windowSize = handler.connection().local().flowController().windowSize(handler.connection().connectionStream());
        this.maxConcurrentStreams = 0xFFFFFFFFL;
    }

    VertxInternal vertx() {
        return this.vertx;
    }

    NetSocket toNetSocket(VertxHttp2Stream stream) {
        VertxHttp2NetSocket<Http2ConnectionBase> rempl = new VertxHttp2NetSocket<Http2ConnectionBase>(this, stream.stream, !stream.isNotWritable());
        this.streams.put(stream.stream.id(), (VertxHttp2Stream)rempl);
        return rempl;
    }

    @Override
    public void handleClosed() {
        super.handleClosed();
    }

    @Override
    protected void handleInterestedOpsChanged() {
    }

    @Override
    protected void handleIdle() {
        super.handleIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void onConnectionError(Throwable cause) {
        ArrayList copy;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            copy = new ArrayList(this.streams.values());
        }
        for (VertxHttp2Stream stream : copy) {
            this.context.executeFromIO(v -> stream.handleException(cause));
        }
        this.handleException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStreamError(int streamId, Throwable cause) {
        VertxHttp2Stream stream;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            stream = this.streams.get(streamId);
        }
        if (stream != null) {
            stream.handleException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStreamWritabilityChanged(Http2Stream s2) {
        VertxHttp2Stream stream;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            stream = this.streams.get(s2.id());
        }
        if (stream != null) {
            this.context.executeFromIO(v -> stream.onWritabilityChanged());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStreamClosed(Http2Stream stream) {
        VertxHttp2Stream removed;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            removed = this.streams.remove(stream.id());
            if (removed == null) {
                return;
            }
        }
        this.context.executeFromIO(v -> removed.handleClose());
        this.checkShutdownHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            if (this.goneAway) {
                return false;
            }
            this.goneAway = true;
        }
        this.checkShutdownHandler();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        Handler<GoAway> handler;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            if (this.goneAway) {
                return false;
            }
            this.goneAway = true;
            handler = this.goAwayHandler;
        }
        if (handler != null) {
            Buffer buffer = Buffer.buffer(debugData);
            this.context.executeFromIO(v -> handler.handle(new GoAway().setErrorCode(errorCode).setLastStreamId(lastStreamId).setDebugData(buffer)));
        }
        this.checkShutdownHandler();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        VertxHttp2Stream stream;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            stream = this.streams.get(streamId);
        }
        if (stream != null) {
            StreamPriority streamPriority = new StreamPriority().setDependency(streamDependency).setWeight(weight).setExclusive(exclusive);
            this.context.executeFromIO(v -> stream.handlePriorityChange(streamPriority));
        }
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSettingsAckRead(ChannelHandlerContext ctx) {
        Handler<Void> handler;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            handler = this.updateSettingsHandlers.poll();
        }
        if (handler != null) {
            this.context.executeFromIO(handler);
        }
    }

    protected void concurrencyChanged(long concurrency) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSettingsRead(ChannelHandlerContext ctx, ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Settings settings) {
        Handler<Http2Settings> handler;
        boolean changed;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            Long val = settings.maxConcurrentStreams();
            if (val != null) {
                changed = this.remoteSettings != null ? val != this.maxConcurrentStreams : false;
                this.maxConcurrentStreams = val;
            } else {
                changed = false;
            }
            this.remoteSettings = settings;
            handler = this.remoteSettingsHandler;
        }
        if (handler != null) {
            this.context.executeFromIO(HttpUtils.toVertxSettings(settings), handler);
        }
        if (changed) {
            this.concurrencyChanged(this.maxConcurrentStreams);
        }
    }

    @Override
    public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
        Handler<Buffer> handler = this.pingHandler;
        if (handler != null) {
            Buffer buff = Buffer.buffer().appendLong(data);
            this.context.executeFromIO(v -> handler.handle(buff));
        }
    }

    @Override
    public void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
        Handler<AsyncResult<Buffer>> handler = this.pongHandlers.poll();
        if (handler != null) {
            this.context.executeFromIO(v -> {
                Buffer buff = Buffer.buffer().appendLong(data);
                handler.handle(Future.succeededFuture(buff));
            });
        }
    }

    @Override
    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
    }

    @Override
    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    @Override
    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
        VertxHttp2Stream req;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            req = this.streams.get(streamId);
        }
        if (req != null) {
            Buffer buff = Buffer.buffer(Http2ConnectionBase.safeBuffer(payload, ctx.alloc()));
            this.context.executeFromIO(v -> req.handleCustomFrame(frameType, flags.value(), buff));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        VertxHttp2Stream req;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            req = this.streams.get(streamId);
            if (req == null) {
                return;
            }
        }
        this.context.executeFromIO(v -> req.onResetRead(errorCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        VertxHttp2Stream req;
        int[] consumed = new int[]{padding};
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            req = this.streams.get(streamId);
        }
        if (req != null) {
            data = Http2ConnectionBase.safeBuffer(data, ctx.alloc());
            Buffer buff = Buffer.buffer(data);
            this.context.executeFromIO(v -> {
                int len = buff.length();
                if (req.onDataRead(buff)) {
                    consumed[0] = consumed[0] + len;
                }
            });
            if (endOfStream) {
                this.context.executeFromIO(v -> req.onEnd());
            }
        }
        return consumed[0];
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public HttpConnection setWindowSize(int windowSize) {
        try {
            Http2Stream stream = this.handler.encoder().connection().connectionStream();
            int delta = windowSize - this.windowSize;
            this.handler.decoder().flowController().incrementWindowSize(stream, delta);
            this.windowSize = windowSize;
            return this;
        }
        catch (Http2Exception e) {
            throw new VertxException(e);
        }
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        if (errorCode < 0L) {
            throw new IllegalArgumentException();
        }
        if (lastStreamId < 0) {
            lastStreamId = this.handler.connection().remote().lastStreamCreated();
        }
        this.handler.writeGoAway(errorCode, lastStreamId, debugData != null ? debugData.getByteBuf() : Unpooled.EMPTY_BUFFER);
        return this;
    }

    @Override
    public synchronized HttpConnection goAwayHandler(Handler<GoAway> handler) {
        this.goAwayHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpConnection shutdownHandler(Handler<Void> handler) {
        this.shutdownHandler = handler;
        return this;
    }

    @Override
    public HttpConnection shutdown(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout value " + timeout);
        }
        this.handler.gracefulShutdownTimeoutMillis(timeout);
        this.channel().close();
        return this;
    }

    @Override
    public Http2ConnectionBase closeHandler(Handler<Void> handler) {
        return (Http2ConnectionBase)super.closeHandler(handler);
    }

    @Override
    public void close() {
        ChannelPromise promise = this.chctx.newPromise();
        this.flush(promise);
        promise.addListener(future -> this.shutdown(0L));
    }

    @Override
    public synchronized HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        this.remoteSettingsHandler = handler;
        return this;
    }

    @Override
    public synchronized Http2Settings remoteSettings() {
        return HttpUtils.toVertxSettings(this.remoteSettings);
    }

    @Override
    public synchronized Http2Settings settings() {
        return HttpUtils.toVertxSettings(this.localSettings);
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings) {
        return this.updateSettings(settings, null);
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, @Nullable Handler<AsyncResult<Void>> completionHandler) {
        ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Settings settingsUpdate = HttpUtils.fromVertxSettings(settings);
        this.updateSettings(settingsUpdate, completionHandler);
        return this;
    }

    protected void updateSettings(ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Settings settingsUpdate, Handler<AsyncResult<Void>> completionHandler) {
        ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2Settings current = this.handler.decoder().localSettings();
        for (Map.Entry entry : current.entrySet()) {
            Character key = entry.getKey();
            if (!Objects.equals(settingsUpdate.get(key), entry.getValue())) continue;
            settingsUpdate.remove(key);
        }
        Handler<Void> pending = v -> {
            Http2ConnectionBase http2ConnectionBase = this;
            synchronized (http2ConnectionBase) {
                this.localSettings.putAll(settingsUpdate);
            }
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
        };
        this.updateSettingsHandlers.add(pending);
        this.handler.writeSettings(settingsUpdate).addListener((GenericFutureListener<? extends ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.Future>)fut -> {
            if (!fut.isSuccess()) {
                Http2ConnectionBase http2ConnectionBase = this;
                synchronized (http2ConnectionBase) {
                    this.updateSettingsHandlers.remove(pending);
                }
                if (completionHandler != null) {
                    completionHandler.handle(Future.failedFuture(fut.cause()));
                }
            }
        }));
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        if (data.length() != 8) {
            throw new IllegalArgumentException("Ping data must be exactly 8 bytes");
        }
        this.handler.writePing(data.getLong(0)).addListener((GenericFutureListener<? extends ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.Future>)fut -> {
            if (fut.isSuccess()) {
                Http2ConnectionBase http2ConnectionBase = this;
                synchronized (http2ConnectionBase) {
                    this.pongHandlers.add(pongHandler);
                }
            } else {
                pongHandler.handle(Future.failedFuture(fut.cause()));
            }
        }));
        return this;
    }

    @Override
    public synchronized HttpConnection pingHandler(Handler<Buffer> handler) {
        this.pingHandler = handler;
        return this;
    }

    @Override
    public Http2ConnectionBase exceptionHandler(Handler<Throwable> handler) {
        return (Http2ConnectionBase)super.exceptionHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdownHandler() {
        Handler<Void> shutdownHandler;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            if (this.shutdown) {
                return;
            }
            Http2Connection conn = this.handler.connection();
            if (!conn.goAwayReceived() && !conn.goAwaySent() || conn.numActiveStreams() > 0) {
                return;
            }
            this.shutdown = true;
            shutdownHandler = this.shutdownHandler;
        }
        if (shutdownHandler != null) {
            this.context.executeFromIO(shutdownHandler);
        }
    }
}

