/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpClientRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpClientResponse;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpMethod;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.StreamResetException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpClientImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpClientRequestImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpUtils;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.NoStackTraceTimeoutException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;

public abstract class HttpClientRequestBase
implements HttpClientRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    protected final HttpClientImpl client;
    protected final HttpMethod method;
    protected final String uri;
    protected final String path;
    protected final String query;
    protected final String host;
    protected final int port;
    protected final SocketAddress server;
    protected final boolean ssl;
    private Handler<Throwable> exceptionHandler;
    private long currentTimeoutTimerId = -1L;
    private long currentTimeoutMs;
    private long lastDataReceived;
    protected Throwable exceptionOccurred;
    private boolean paused;
    private HttpClientResponse response;

    HttpClientRequestBase(HttpClientImpl client, boolean ssl, HttpMethod method, SocketAddress server, String host, int port, String uri) {
        this.client = client;
        this.uri = uri;
        this.method = method;
        this.server = server;
        this.host = host;
        this.port = port;
        this.path = uri.length() > 0 ? HttpUtils.parsePath(uri) : "";
        this.query = HttpUtils.parseQuery(uri);
        this.ssl = ssl;
    }

    protected void checkEnded() {
    }

    protected String hostHeader() {
        if (this.port == 80 && !this.ssl || this.port == 443 && this.ssl) {
            return this.host;
        }
        return this.host + ':' + this.port;
    }

    @Override
    public String absoluteURI() {
        return (this.ssl ? "https://" : "http://") + this.hostHeader() + this.uri;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    public String host() {
        return this.server.host();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public synchronized HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        if (handler != null) {
            this.checkEnded();
            this.exceptionHandler = handler;
        } else {
            this.exceptionHandler = null;
        }
        return this;
    }

    synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public synchronized HttpClientRequest setTimeout(long timeoutMs) {
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("Timeout must be a positive value");
        }
        this.cancelTimeout();
        this.currentTimeoutMs = timeoutMs;
        this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, id -> this.handleTimeout(timeoutMs));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Throwable t) {
        Handler<Throwable> handler;
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            this.cancelTimeout();
            this.exceptionOccurred = t;
            handler = this.exceptionHandler != null ? this.exceptionHandler : log::error;
        }
        handler.handle(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponse(HttpClientResponse resp) {
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            this.response = resp;
        }
        this.checkHandleResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHandleResponse() {
        HttpClientResponse resp;
        long timeoutMS;
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            if (this.response != null) {
                if (this.paused) {
                    return;
                }
            } else {
                return;
            }
            timeoutMS = this.cancelTimeout();
            resp = this.response;
            this.response = null;
        }
        try {
            this.handleResponse(resp, timeoutMS);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    abstract void handleResponse(HttpClientResponse var1, long var2);

    private synchronized long cancelTimeout() {
        long ret = this.currentTimeoutTimerId;
        if (ret != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
            ret = this.currentTimeoutMs;
            this.currentTimeoutMs = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(long timeoutMs) {
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            long now;
            long timeSinceLastData;
            long delta;
            this.currentTimeoutMs = 0L;
            this.currentTimeoutTimerId = -1L;
            if (this.lastDataReceived > 0L && (delta = timeoutMs - (timeSinceLastData = (now = System.currentTimeMillis()) - this.lastDataReceived)) > 0L) {
                this.lastDataReceived = 0L;
                this.setTimeout(delta);
                return;
            }
        }
        String msg = "The timeout period of " + timeoutMs + "ms has been exceeded while executing " + (Object)((Object)this.method) + " " + this.uri + " for server " + this.server;
        this.reset(new NoStackTraceTimeoutException(msg));
    }

    synchronized void dataReceived() {
        if (this.currentTimeoutTimerId != -1L) {
            this.lastDataReceived = System.currentTimeMillis();
        }
    }

    @Override
    public boolean reset(long code) {
        return this.reset(new StreamResetException(code));
    }

    abstract boolean reset(Throwable var1);

    @Override
    public HttpClientRequest pause() {
        this.paused = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest resume() {
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            if (!this.paused) {
                return this;
            }
            this.paused = false;
        }
        this.checkHandleResponse();
        return this;
    }

    @Override
    public synchronized HttpClientRequest fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException();
        }
        if (amount > 0L) {
            this.resume();
        }
        return this;
    }
}

