/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl;

import java.util.ArrayList;
import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPipeline;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.compression.ZlibCodecFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.GenericFutureListener;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpConnection;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.ServerWebSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.Http1xServerConnection;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpServerConnection;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpServerImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.WebSocketRequestHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.ConnectionBase;

public class HttpHandlers
implements Handler<HttpServerConnection> {
    final HttpServerImpl server;
    final Handler<HttpServerRequest> requestHandler;
    final Handler<ServerWebSocket> wsHandler;
    final Handler<HttpConnection> connectionHandler;
    final Handler<Throwable> exceptionHandler;

    public HttpHandlers(HttpServerImpl server, Handler<HttpServerRequest> requestHandler, Handler<ServerWebSocket> wsHandler, Handler<HttpConnection> connectionHandler, Handler<Throwable> exceptionHandler) {
        this.server = server;
        this.requestHandler = requestHandler;
        this.wsHandler = wsHandler;
        this.connectionHandler = connectionHandler;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void handle(HttpServerConnection conn) {
        this.server.connectionMap.put(conn.channel(), (ConnectionBase)((Object)conn));
        conn.channel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)fut -> this.server.connectionMap.remove(conn.channel())));
        WebSocketRequestHandler requestHandler = this.requestHandler;
        if (!HttpServerImpl.DISABLE_WEBSOCKETS && conn instanceof Http1xServerConnection) {
            requestHandler = new WebSocketRequestHandler(this.server.metrics, this);
            Http1xServerConnection c = (Http1xServerConnection)conn;
            this.initializeWebsocketExtensions(c.channelHandlerContext().pipeline());
        }
        conn.exceptionHandler(this.exceptionHandler);
        conn.handler(requestHandler);
        if (this.connectionHandler != null) {
            this.connectionHandler.handle(conn);
        }
    }

    private void initializeWebsocketExtensions(ChannelPipeline pipeline) {
        ArrayList<WebSocketServerExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketServerExtensionHandshaker>();
        if (this.server.options.getPerFrameWebsocketCompressionSupported()) {
            extensionHandshakers.add(new DeflateFrameServerExtensionHandshaker(this.server.options.getWebsocketCompressionLevel()));
        }
        if (this.server.options.getPerMessageWebsocketCompressionSupported()) {
            extensionHandshakers.add(new PerMessageDeflateServerExtensionHandshaker(this.server.options.getWebsocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, this.server.options.getWebsocketAllowServerNoContext(), this.server.options.getWebsocketPreferredClientNoContext()));
        }
        if (!extensionHandshakers.isEmpty()) {
            WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(extensionHandshakers.toArray(new WebSocketServerExtensionHandshaker[extensionHandshakers.size()]));
            pipeline.addBefore("handler", "websocketExtensionHandler", extensionHandler);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHandlers that = (HttpHandlers)o;
        if (!Objects.equals(this.requestHandler, that.requestHandler)) {
            return false;
        }
        if (!Objects.equals(this.wsHandler, that.wsHandler)) {
            return false;
        }
        if (!Objects.equals(this.connectionHandler, that.connectionHandler)) {
            return false;
        }
        return Objects.equals(this.exceptionHandler, that.exceptionHandler);
    }

    public int hashCode() {
        int result = 0;
        if (this.requestHandler != null) {
            result = 31 * result + this.requestHandler.hashCode();
        }
        if (this.wsHandler != null) {
            result = 31 * result + this.wsHandler.hashCode();
        }
        if (this.connectionHandler != null) {
            result = 31 * result + this.connectionHandler.hashCode();
        }
        if (this.exceptionHandler != null) {
            result = 31 * result + this.exceptionHandler.hashCode();
        }
        return result;
    }
}

