/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl;

import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.Unpooled;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelFutureListener;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelInitializer;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPipeline;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.EventLoop;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpContentDecompressor;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http2.Http2ConnectionHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.logging.LoggingHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.SniHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.SslHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.stream.ChunkedWriteHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.timeout.IdleState;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.timeout.IdleStateEvent;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.timeout.IdleStateHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.Http1xOrH2CHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.Http1xServerConnection;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.Http1xUpgradeToH2CHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.Http2ServerConnection;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpChunkContentCompressor;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpServerConnection;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpServerImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.VertxHttpRequestDecoder;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.VertxHttpResponseEncoder;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.cgbystrom.FlashPolicyHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.ContextInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.HandlerHolder;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.SSLHelper;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.SslHandshakeCompletionHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.VertxHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.HttpServerMetrics;

public class HttpServerChannelInitializer
extends ChannelInitializer<Channel> {
    private final VertxInternal vertx;
    private final SSLHelper sslHelper;
    private final HttpServerOptions options;
    private final String serverOrigin;
    private final HttpServerMetrics metrics;
    private final boolean logEnabled;
    private final boolean disableH2C;
    private final Function<EventLoop, HandlerHolder<? extends Handler<HttpServerConnection>>> connectionHandler;
    private final Function<EventLoop, HandlerHolder<? extends Handler<Throwable>>> errorHandler;

    public HttpServerChannelInitializer(VertxInternal vertx, SSLHelper sslHelper, HttpServerOptions options, String serverOrigin, HttpServerMetrics metrics, boolean disableH2C, Function<EventLoop, HandlerHolder<? extends Handler<HttpServerConnection>>> connectionHandler, Function<EventLoop, HandlerHolder<? extends Handler<Throwable>>> errorHandler) {
        this.vertx = vertx;
        this.sslHelper = sslHelper;
        this.options = options;
        this.serverOrigin = serverOrigin;
        this.metrics = metrics;
        this.logEnabled = options.getLogActivity();
        this.disableH2C = disableH2C;
        this.connectionHandler = connectionHandler;
        this.errorHandler = errorHandler;
    }

    @Override
    protected void initChannel(final Channel ch) {
        final ChannelPipeline pipeline = ch.pipeline();
        if (this.sslHelper.isSSL()) {
            ch.pipeline().addFirst("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler(ar -> {
                if (ar.succeeded()) {
                    if (this.options.isUseAlpn()) {
                        SslHandler sslHandler = pipeline.get(SslHandler.class);
                        String protocol = sslHandler.applicationProtocol();
                        if ("h2".equals(protocol)) {
                            this.handleHttp2(ch);
                        } else {
                            this.handleHttp1(ch);
                        }
                    } else {
                        this.handleHttp1(ch);
                    }
                } else {
                    this.handleException(ch, ar.cause());
                }
            }));
            if (this.options.isSni()) {
                SniHandler sniHandler = new SniHandler(this.sslHelper.serverNameMapper(this.vertx));
                pipeline.addFirst(sniHandler);
            } else {
                SslHandler handler = new SslHandler(this.sslHelper.createEngine(this.vertx));
                handler.setHandshakeTimeout(this.sslHelper.getSslHandshakeTimeout(), this.sslHelper.getSslHandshakeTimeoutUnit());
                pipeline.addFirst("ssl", (ChannelHandler)handler);
            }
        } else if (this.disableH2C) {
            this.handleHttp1(ch);
        } else {
            IdleStateHandler idle;
            if (this.options.getIdleTimeout() > 0) {
                idle = new IdleStateHandler(0L, 0L, this.options.getIdleTimeout(), this.options.getIdleTimeoutUnit());
                pipeline.addLast("idle", (ChannelHandler)idle);
            } else {
                idle = null;
            }
            pipeline.addLast(new Http1xOrH2CHandler(){

                @Override
                protected void configure(ChannelHandlerContext ctx, boolean h2c) {
                    if (idle != null) {
                        pipeline.remove(idle);
                    }
                    if (h2c) {
                        HttpServerChannelInitializer.this.handleHttp2(ctx.channel());
                    } else {
                        HttpServerChannelInitializer.this.handleHttp1(ch);
                    }
                }

                @Override
                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
                        ctx.close();
                    }
                }

                @Override
                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    super.exceptionCaught(ctx, cause);
                    HttpServerChannelInitializer.this.handleException(ch, cause);
                }
            });
        }
    }

    private void handleException(Channel ch, Throwable cause) {
        HandlerHolder<? extends Handler<Throwable>> holder = this.errorHandler.apply(ch.eventLoop());
        if (holder != null) {
            holder.context.executeFromIO(cause, (Handler)holder.handler);
        }
    }

    private void handleHttp1(Channel ch) {
        HandlerHolder<? extends Handler<HttpServerConnection>> holder = this.connectionHandler.apply(ch.eventLoop());
        if (holder == null) {
            this.sendServiceUnavailable(ch);
            return;
        }
        this.configureHttp1OrH2C(ch.pipeline(), holder);
    }

    private void sendServiceUnavailable(Channel ch) {
        ch.writeAndFlush(Unpooled.copiedBuffer("HTTP/1.1 503 Service Unavailable\r\nContent-Length:0\r\n\r\n", StandardCharsets.ISO_8859_1)).addListener(ChannelFutureListener.CLOSE);
    }

    private void handleHttp2(Channel ch) {
        HandlerHolder<? extends Handler<HttpServerConnection>> holder = this.connectionHandler.apply(ch.eventLoop());
        if (holder == null) {
            ch.close();
            return;
        }
        VertxHttp2ConnectionHandler<Http2ServerConnection> handler = this.buildHttp2ConnectionHandler(holder.context, (Handler)holder.handler);
        ch.pipeline().addLast("handler", handler);
        this.configureHttp2(ch.pipeline());
    }

    void configureHttp2(ChannelPipeline pipeline) {
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addBefore("handler", "idle", new IdleStateHandler(0L, 0L, this.options.getIdleTimeout(), this.options.getIdleTimeoutUnit()));
        }
    }

    VertxHttp2ConnectionHandler<Http2ServerConnection> buildHttp2ConnectionHandler(ContextInternal ctx, Handler<HttpServerConnection> handler_) {
        Http2ConnectionHandler handler = ((VertxHttp2ConnectionHandlerBuilder)new VertxHttp2ConnectionHandlerBuilder().server(true)).useCompression(this.options.isCompressionSupported()).useDecompression(this.options.isDecompressionSupported()).compressionLevel(this.options.getCompressionLevel()).initialSettings(this.options.getInitialSettings()).connectionFactory(connHandler -> new Http2ServerConnection(ctx, this.serverOrigin, (VertxHttp2ConnectionHandler)connHandler, this.options, this.metrics)).logEnabled(this.logEnabled).build();
        ((VertxHttp2ConnectionHandler)handler).addHandler(conn -> {
            if (this.metrics != null) {
                conn.metric(this.metrics.connected(conn.remoteAddress(), conn.remoteName()));
            }
            if (this.options.getHttp2ConnectionWindowSize() > 0) {
                conn.setWindowSize(this.options.getHttp2ConnectionWindowSize());
            }
            ctx.executeFromIO(conn, handler_);
        });
        return handler;
    }

    private void configureHttp1OrH2C(ChannelPipeline pipeline, HandlerHolder<? extends Handler<HttpServerConnection>> holder) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (HttpServerImpl.USE_FLASH_POLICY_HANDLER) {
            pipeline.addLast("flashpolicy", (ChannelHandler)new FlashPolicyHandler());
        }
        pipeline.addLast("httpDecoder", (ChannelHandler)new VertxHttpRequestDecoder(this.options));
        pipeline.addLast("httpEncoder", (ChannelHandler)new VertxHttpResponseEncoder());
        if (this.options.isDecompressionSupported()) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(false));
        }
        if (this.options.isCompressionSupported()) {
            pipeline.addLast("deflater", (ChannelHandler)new HttpChunkContentCompressor(this.options.getCompressionLevel()));
        }
        if (this.sslHelper.isSSL() || this.options.isCompressionSupported()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0L, 0L, this.options.getIdleTimeout(), this.options.getIdleTimeoutUnit()));
        }
        if (this.disableH2C) {
            this.configureHttp1(pipeline, holder);
        } else {
            pipeline.addLast("h2c", (ChannelHandler)new Http1xUpgradeToH2CHandler(this, holder, this.options.isCompressionSupported(), this.options.isDecompressionSupported()));
        }
    }

    void configureHttp1(ChannelPipeline pipeline, HandlerHolder<? extends Handler<HttpServerConnection>> holder) {
        VertxHandler<Http1xServerConnection> handler = VertxHandler.create(holder.context, chctx -> {
            Http1xServerConnection conn = new Http1xServerConnection(holder.context.owner(), this.sslHelper, this.options, (ChannelHandlerContext)chctx, holder.context, this.serverOrigin, this.metrics);
            return conn;
        });
        pipeline.addLast("handler", handler);
        Http1xServerConnection conn = handler.getConnection();
        if (this.metrics != null) {
            holder.context.executeFromIO(v -> conn.metric(this.metrics.connected(conn.remoteAddress(), conn.remoteName())));
        }
        holder.context.executeFromIO(conn, (Handler)holder.handler);
    }
}

