/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelInboundHandlerAdapter;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPipeline;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.DefaultFullHttpResponse;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.FullHttpResponse;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpContent;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpContentDecompressor;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpResponse;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.LastHttpContent;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.WebsocketRejectedException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HeadersAdaptor;

class WebSocketHandshakeInboundHandler
extends ChannelInboundHandlerAdapter {
    private final Handler<AsyncResult<HeadersAdaptor>> wsHandler;
    private final WebSocketClientHandshaker handshaker;
    private ChannelHandlerContext chctx;
    private FullHttpResponse response;

    WebSocketHandshakeInboundHandler(WebSocketClientHandshaker handshaker, Handler<AsyncResult<HeadersAdaptor>> wsHandler) {
        this.handshaker = handshaker;
        this.wsHandler = wsHandler;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.chctx = ctx;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.wsHandler.handle(Future.failedFuture(new WebSocketHandshakeException("Connection closed while handshake in process")));
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse resp = (HttpResponse)msg;
            this.response = new DefaultFullHttpResponse(resp.protocolVersion(), resp.status());
            this.response.headers().add(resp.headers());
        }
        if (msg instanceof HttpContent && this.response != null) {
            this.response.content().writeBytes(((HttpContent)msg).content());
            if (msg instanceof LastHttpContent) {
                this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                ChannelPipeline pipeline = this.chctx.pipeline();
                pipeline.remove(this);
                HttpContentDecompressor handler = pipeline.get(HttpContentDecompressor.class);
                if (handler != null) {
                    ctx.pipeline().remove(handler);
                }
                Future<HeadersAdaptor> fut = this.handshakeComplete(this.response);
                this.wsHandler.handle(fut);
            }
        }
    }

    private Future<HeadersAdaptor> handshakeComplete(FullHttpResponse response) {
        if (response.status().code() != 101) {
            WebsocketRejectedException failure = new WebsocketRejectedException(response.status().code());
            return Future.failedFuture(failure);
        }
        try {
            this.handshaker.finishHandshake(this.chctx.channel(), response);
            return Future.succeededFuture(new HeadersAdaptor(response.headers()));
        }
        catch (WebSocketHandshakeException e) {
            return Future.failedFuture(e);
        }
    }
}

