/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.headers;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBufUtil;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.AsciiString;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.CharsetUtil;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.HashingStrategy;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.MultiMap;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpHeaders;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpUtils;

public final class VertxHttpHeaders
extends ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpHeaders
implements MultiMap {
    private final MapEntry[] entries = new MapEntry[16];
    private final MapEntry head;
    private static final int COLON_AND_SPACE_SHORT = 14880;
    static final int CRLF_SHORT = 3338;

    @Override
    public MultiMap setAll(MultiMap headers) {
        return this.set0(headers);
    }

    @Override
    public MultiMap setAll(Map<String, String> headers) {
        return this.set0(headers.entrySet());
    }

    @Override
    public int size() {
        return this.names().size();
    }

    public VertxHttpHeaders() {
        this.head.before = this.head.after = (this.head = new MapEntry());
    }

    @Override
    public VertxHttpHeaders add(CharSequence name, CharSequence value) {
        Objects.requireNonNull(value);
        int h2 = AsciiString.hashCode(name);
        int i = h2 & 0xF;
        this.add0(h2, i, name, value);
        return this;
    }

    @Override
    public VertxHttpHeaders add(CharSequence name, Object value) {
        return this.add(name, (CharSequence)value);
    }

    @Override
    public ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpHeaders add(String name, Object value) {
        return this.add((CharSequence)name, (CharSequence)value);
    }

    @Override
    public VertxHttpHeaders add(String name, String strVal) {
        return this.add((CharSequence)name, (CharSequence)strVal);
    }

    public VertxHttpHeaders add(CharSequence name, Iterable values) {
        int h2 = AsciiString.hashCode(name);
        int i = h2 & 0xF;
        for (Object vstr : values) {
            this.add0(h2, i, name, (CharSequence)vstr);
        }
        return this;
    }

    public VertxHttpHeaders add(String name, Iterable values) {
        return this.add((CharSequence)name, values);
    }

    @Override
    public MultiMap addAll(MultiMap headers) {
        return this.addAll(headers.entries());
    }

    @Override
    public MultiMap addAll(Map<String, String> map) {
        return this.addAll(map.entrySet());
    }

    private MultiMap addAll(Iterable<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> entry : headers) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public VertxHttpHeaders remove(CharSequence name) {
        Objects.requireNonNull(name, "name");
        int h2 = AsciiString.hashCode(name);
        int i = h2 & 0xF;
        this.remove0(h2, i, name);
        return this;
    }

    @Override
    public VertxHttpHeaders remove(String name) {
        return this.remove((CharSequence)name);
    }

    @Override
    public VertxHttpHeaders set(CharSequence name, CharSequence value) {
        return this.set0(name, value);
    }

    @Override
    public VertxHttpHeaders set(String name, String value) {
        return this.set((CharSequence)name, (CharSequence)value);
    }

    @Override
    public VertxHttpHeaders set(String name, Object value) {
        return this.set((CharSequence)name, (CharSequence)value);
    }

    @Override
    public VertxHttpHeaders set(CharSequence name, Object value) {
        return this.set(name, (CharSequence)value);
    }

    public VertxHttpHeaders set(CharSequence name, Iterable values) {
        Objects.requireNonNull(values, "values");
        int h2 = AsciiString.hashCode(name);
        int i = h2 & 0xF;
        this.remove0(h2, i, name);
        for (Object v : values) {
            if (v == null) break;
            this.add0(h2, i, name, (CharSequence)v);
        }
        return this;
    }

    public VertxHttpHeaders set(String name, Iterable values) {
        return this.set((CharSequence)name, values);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        HashingStrategy<CharSequence> strategy;
        int h2 = AsciiString.hashCode(name);
        int i = h2 & 0xF;
        MapEntry e = this.entries[i];
        HashingStrategy<CharSequence> hashingStrategy = strategy = ignoreCase ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER;
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h2 && (name == key || AsciiString.contentEqualsIgnoreCase(name, key)) && strategy.equals(value, e.getValue())) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.contains((CharSequence)name, (CharSequence)value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.get0(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.contains((CharSequence)name);
    }

    @Override
    public String get(CharSequence name) {
        Objects.requireNonNull(name, "name");
        CharSequence ret = this.get0(name);
        return ret != null ? ret.toString() : null;
    }

    @Override
    public String get(String name) {
        return this.get((CharSequence)name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        Objects.requireNonNull(name, "name");
        LinkedList<String> values = new LinkedList<String>();
        int h2 = AsciiString.hashCode(name);
        int i = h2 & 0xF;
        MapEntry e = this.entries[i];
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h2 && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                values.addFirst(e.getValue().toString());
            }
            e = e.next;
        }
        return values;
    }

    @Override
    public List<String> getAll(String name) {
        return this.getAll((CharSequence)name);
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        MapEntry e = this.head.after;
        while (e != this.head) {
            action.accept(new AbstractMap.SimpleEntry<String, String>(e.key.toString(), e.value.toString()));
            e = e.after;
        }
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return MultiMap.super.entries();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new Iterator<Map.Entry<String, String>>(){
            MapEntry curr;
            {
                this.curr = VertxHttpHeaders.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.curr.after != VertxHttpHeaders.this.head;
            }

            @Override
            public Map.Entry<String, String> next() {
                final MapEntry next = this.curr.after;
                if (next == VertxHttpHeaders.this.head) {
                    throw new NoSuchElementException();
                }
                this.curr = next;
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return next.key.toString();
                    }

                    @Override
                    public String getValue() {
                        return next.value.toString();
                    }

                    @Override
                    public String setValue(String value) {
                        return next.setValue(value).toString();
                    }

                    public String toString() {
                        return this.getKey() + ": " + this.getValue();
                    }
                };
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        MapEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey().toString());
            e = e.after;
        }
        return names;
    }

    @Override
    public VertxHttpHeaders clear() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.head.before = this.head.after = this.head;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    @Override
    public Integer getInt(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(CharSequence name, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short getShort(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(CharSequence name, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getTimeMillis(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new Iterator<Map.Entry<CharSequence, CharSequence>>(){
            MapEntry current;
            {
                this.current = ((VertxHttpHeaders)VertxHttpHeaders.this).head.after;
            }

            @Override
            public boolean hasNext() {
                return this.current != VertxHttpHeaders.this.head;
            }

            @Override
            public Map.Entry<CharSequence, CharSequence> next() {
                MapEntry next = this.current;
                this.current = this.current.after;
                return next;
            }
        };
    }

    @Override
    public ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpHeaders addInt(CharSequence name, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpHeaders addShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpHeaders setInt(CharSequence name, int value) {
        return this.set(name, (CharSequence)Integer.toString(value));
    }

    @Override
    public ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpHeaders setShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    public void encode(ByteBuf buf) {
        MapEntry current = this.head.after;
        while (current != this.head) {
            VertxHttpHeaders.encoderHeader(current.key, current.value, buf);
            current = current.after;
        }
    }

    static void encoderHeader(CharSequence name, CharSequence value, ByteBuf buf) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset = buf.writerIndex();
        VertxHttpHeaders.writeAscii(buf, offset, name);
        ByteBufUtil.setShortBE(buf, offset += nameLen, 14880);
        VertxHttpHeaders.writeAscii(buf, offset += 2, value);
        ByteBufUtil.setShortBE(buf, offset += valueLen, 3338);
        buf.writerIndex(offset += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)value, 0, buf, offset, value.length());
        } else {
            buf.setCharSequence(offset, value, CharsetUtil.US_ASCII);
        }
    }

    private void remove0(int h2, int i, CharSequence name) {
        MapEntry next;
        MapEntry e;
        block4: {
            e = this.entries[i];
            if (e == null) {
                return;
            }
            while (true) {
                CharSequence key = e.key;
                if (e.hash != h2 || name != key && !AsciiString.contentEqualsIgnoreCase(name, key)) break block4;
                e.remove();
                MapEntry next2 = e.next;
                if (next2 == null) break;
                this.entries[i] = next2;
                e = next2;
            }
            this.entries[i] = null;
            return;
        }
        while ((next = e.next) != null) {
            CharSequence key = next.key;
            if (next.hash == h2 && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
    }

    private void add0(int h2, int i, CharSequence name, CharSequence value) {
        MapEntry newEntry;
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name, value);
        }
        MapEntry e = this.entries[i];
        this.entries[i] = newEntry = new MapEntry(h2, name, value);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    private VertxHttpHeaders set0(CharSequence name, CharSequence strVal) {
        int h2 = AsciiString.hashCode(name);
        int i = h2 & 0xF;
        this.remove0(h2, i, name);
        if (strVal != null) {
            this.add0(h2, i, name, strVal);
        }
        return this;
    }

    private CharSequence get0(CharSequence name) {
        int h2 = AsciiString.hashCode(name);
        int i = h2 & 0xF;
        MapEntry e = this.entries[i];
        CharSequence value = null;
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h2 && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                value = e.getValue();
            }
            e = e.next;
        }
        return value;
    }

    private MultiMap set0(Iterable<Map.Entry<String, String>> map) {
        this.clear();
        for (Map.Entry<String, String> entry : map) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private static final class MapEntry
    implements Map.Entry<CharSequence, CharSequence> {
        final int hash;
        final CharSequence key;
        CharSequence value;
        MapEntry next;
        MapEntry before;
        MapEntry after;

        MapEntry() {
            this.hash = -1;
            this.key = null;
            this.value = null;
        }

        MapEntry(int hash, CharSequence key, CharSequence value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(MapEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            Objects.requireNonNull(value, "value");
            if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
                HttpUtils.validateHeaderValue(value);
            }
            CharSequence oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

