/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.ws;

import java.nio.charset.StandardCharsets;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.Unpooled;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.CharsetUtil;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.ReferenceCounted;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.FrameType;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.ws.WebSocketFrameInternal;

public class WebSocketFrameImpl
implements WebSocketFrameInternal,
ReferenceCounted {
    private final FrameType type;
    private final boolean isFinalFrame;
    private ByteBuf binaryData;
    private boolean closeParsed = false;
    private short closeStatusCode;
    private String closeReason;

    public WebSocketFrameImpl() {
        this(null, Unpooled.EMPTY_BUFFER, true);
    }

    public WebSocketFrameImpl(FrameType frameType) {
        this(frameType, Unpooled.EMPTY_BUFFER, true);
    }

    public WebSocketFrameImpl(String textData) {
        this(textData, true);
    }

    public WebSocketFrameImpl(String textData, boolean isFinalFrame) {
        this.type = FrameType.TEXT;
        this.isFinalFrame = isFinalFrame;
        this.binaryData = Unpooled.copiedBuffer(textData, CharsetUtil.UTF_8);
    }

    public WebSocketFrameImpl(FrameType type, ByteBuf binaryData) {
        this(type, binaryData, true);
    }

    public WebSocketFrameImpl(FrameType type, ByteBuf binaryData, boolean isFinalFrame) {
        this.type = type;
        this.isFinalFrame = isFinalFrame;
        this.binaryData = Unpooled.unreleasableBuffer(binaryData);
    }

    @Override
    public boolean isText() {
        return this.type == FrameType.TEXT;
    }

    @Override
    public boolean isBinary() {
        return this.type == FrameType.BINARY;
    }

    @Override
    public boolean isContinuation() {
        return this.type == FrameType.CONTINUATION;
    }

    @Override
    public boolean isClose() {
        return this.type == FrameType.CLOSE;
    }

    @Override
    public ByteBuf getBinaryData() {
        return this.binaryData;
    }

    @Override
    public String textData() {
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    @Override
    public Buffer binaryData() {
        return Buffer.buffer(this.binaryData);
    }

    @Override
    public void setBinaryData(ByteBuf binaryData) {
        if (this.binaryData != null) {
            this.binaryData.release();
        }
        this.binaryData = binaryData;
    }

    @Override
    public void setTextData(String textData) {
        if (this.binaryData != null) {
            this.binaryData.release();
        }
        this.binaryData = Unpooled.copiedBuffer(textData, CharsetUtil.UTF_8);
    }

    @Override
    public int length() {
        return this.binaryData.readableBytes();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(type: " + (Object)((Object)this.type) + ", data: " + this.getBinaryData() + ')';
    }

    @Override
    public int refCnt() {
        return this.binaryData.refCnt();
    }

    @Override
    public ReferenceCounted retain() {
        return this.binaryData.retain();
    }

    @Override
    public ReferenceCounted retain(int increment) {
        return this.binaryData.retain(increment);
    }

    @Override
    public boolean release() {
        return this.binaryData.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.binaryData.release(decrement);
    }

    @Override
    public ReferenceCounted touch() {
        this.binaryData.touch();
        return this;
    }

    @Override
    public ReferenceCounted touch(Object hint) {
        this.binaryData.touch(hint);
        return this;
    }

    @Override
    public boolean isFinal() {
        return this.isFinalFrame;
    }

    private void parseCloseFrame() {
        int length = this.length();
        if (length < 2) {
            this.closeStatusCode = (short)1000;
            this.closeReason = null;
        } else {
            int index = this.binaryData.readerIndex();
            this.closeStatusCode = this.binaryData.getShort(index);
            this.closeReason = length == 2 ? null : this.binaryData.toString(index + 2, length - 2, StandardCharsets.UTF_8);
        }
    }

    private void checkClose() {
        if (!this.isClose()) {
            throw new IllegalStateException("This should be a close frame");
        }
    }

    @Override
    public short closeStatusCode() {
        this.checkClose();
        if (!this.closeParsed) {
            this.parseCloseFrame();
        }
        return this.closeStatusCode;
    }

    @Override
    public String closeReason() {
        this.checkClose();
        if (!this.closeParsed) {
            this.parseCloseFrame();
        }
        return this.closeReason;
    }

    @Override
    public FrameType type() {
        return this.type;
    }
}

