/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Closeable;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Promise;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;

class CloseHooks {
    private final Logger log;
    private boolean closeHooksRun;
    private Set<Closeable> closeHooks;

    CloseHooks(Logger log) {
        this.log = log;
    }

    synchronized void add(Closeable hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new HashSet<Closeable>();
        }
        this.closeHooks.add(hook);
    }

    synchronized boolean remove(Closeable hook) {
        if (this.closeHooks != null) {
            return this.closeHooks.remove(hook);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Handler<AsyncResult<Void>> completionHandler) {
        HashSet<Closeable> copy = null;
        CloseHooks closeHooks = this;
        synchronized (closeHooks) {
            if (this.closeHooksRun) {
                throw new IllegalStateException("Close hooks already run");
            }
            this.closeHooksRun = true;
            if (this.closeHooks != null && !this.closeHooks.isEmpty()) {
                copy = new HashSet<Closeable>(this.closeHooks);
            }
        }
        if (copy != null && !copy.isEmpty()) {
            int num = copy.size();
            if (num != 0) {
                AtomicInteger count = new AtomicInteger();
                AtomicBoolean failed = new AtomicBoolean();
                for (Closeable hook : copy) {
                    Promise<Void> promise = Promise.promise();
                    promise.future().onComplete(ar -> {
                        if (ar.failed()) {
                            if (failed.compareAndSet(false, true)) {
                                completionHandler.handle(Future.failedFuture(ar.cause()));
                            }
                        } else if (count.incrementAndGet() == num) {
                            completionHandler.handle(Future.succeededFuture());
                        }
                    });
                    try {
                        hook.close(promise);
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)"Failed to run close hooks", t);
                        promise.tryFail(t);
                    }
                }
            } else {
                completionHandler.handle(Future.succeededFuture());
            }
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
    }
}

