/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl;

import java.util.ArrayList;
import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Promise;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.NoStackTraceThrowable;

class FutureImpl<T>
implements Promise<T>,
Future<T> {
    private boolean failed;
    private boolean succeeded;
    private Handler<AsyncResult<T>> handler;
    private T result;
    private Throwable throwable;

    FutureImpl() {
    }

    @Override
    public synchronized T result() {
        return this.result;
    }

    @Override
    public synchronized Throwable cause() {
        return this.throwable;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.succeeded;
    }

    @Override
    public synchronized boolean failed() {
        return this.failed;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.failed || this.succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> onComplete(Handler<AsyncResult<T>> handler) {
        Objects.requireNonNull(handler, "No null handler accepted");
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (!this.isComplete()) {
                if (this.handler == null) {
                    this.handler = handler;
                } else {
                    this.addHandler(handler);
                }
                return this;
            }
        }
        this.dispatch(handler);
        return this;
    }

    private void addHandler(Handler<AsyncResult<T>> h2) {
        Handlers handlers;
        if (this.handler instanceof Handlers) {
            handlers = (Handlers)this.handler;
        } else {
            handlers = new Handlers();
            handlers.add(this.handler);
            this.handler = handlers;
        }
        handlers.add(h2);
    }

    protected void dispatch(Handler<AsyncResult<T>> handler) {
        if (handler instanceof Handlers) {
            for (Handler h2 : (Handlers)handler) {
                h2.handle(this);
            }
        } else {
            handler.handle(this);
        }
    }

    @Override
    public void complete(T result) {
        if (!this.tryComplete(result)) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }

    @Override
    public void complete() {
        if (!this.tryComplete()) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }

    @Override
    public void fail(Throwable cause) {
        if (!this.tryFail(cause)) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }

    @Override
    public void fail(String failureMessage) {
        if (!this.tryFail(failureMessage)) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryComplete(T result) {
        Handler<AsyncResult<T>> h2;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.succeeded || this.failed) {
                return false;
            }
            this.result = result;
            this.succeeded = true;
            h2 = this.handler;
            this.handler = null;
        }
        if (h2 != null) {
            this.dispatch(h2);
        }
        return true;
    }

    @Override
    public boolean tryComplete() {
        return this.tryComplete(null);
    }

    @Override
    public void handle(Future<T> ar) {
        if (ar.succeeded()) {
            this.complete(ar.result());
        } else {
            this.fail(ar.cause());
        }
    }

    @Override
    public Handler<AsyncResult<T>> completer() {
        return this;
    }

    @Override
    public void handle(AsyncResult<T> asyncResult) {
        if (asyncResult.succeeded()) {
            this.complete(asyncResult.result());
        } else {
            this.fail(asyncResult.cause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryFail(Throwable cause) {
        Handler<AsyncResult<T>> h2;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.succeeded || this.failed) {
                return false;
            }
            this.throwable = cause != null ? cause : new NoStackTraceThrowable(null);
            this.failed = true;
            h2 = this.handler;
            this.handler = null;
        }
        if (h2 != null) {
            h2.handle(this);
        }
        return true;
    }

    @Override
    public boolean tryFail(String failureMessage) {
        return this.tryFail(new NoStackTraceThrowable(failureMessage));
    }

    @Override
    public Future<T> future() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.succeeded) {
                return "Future{result=" + this.result + "}";
            }
            if (this.failed) {
                return "Future{cause=" + this.throwable.getMessage() + "}";
            }
            return "Future{unresolved}";
        }
    }

    private class Handlers<T>
    extends ArrayList<Handler<AsyncResult<T>>>
    implements Handler<AsyncResult<T>> {
        private Handlers() {
        }

        @Override
        public void handle(AsyncResult<T> res) {
            for (Handler handler : this) {
                handler.handle(res);
            }
        }
    }
}

