/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Context;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Promise;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.ContextImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.WorkerExecutorInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.WorkerPool;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.Metrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.MetricsProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.PoolMetrics;

class WorkerExecutorImpl
implements MetricsProvider,
WorkerExecutorInternal {
    private final Context ctx;
    private final VertxImpl.SharedWorkerPool pool;
    private boolean closed;

    public WorkerExecutorImpl(Context ctx, VertxImpl.SharedWorkerPool pool) {
        this.ctx = ctx;
        this.pool = pool;
    }

    @Override
    public Metrics getMetrics() {
        return this.pool.metrics();
    }

    @Override
    public boolean isMetricsEnabled() {
        PoolMetrics metrics = this.pool.metrics();
        return metrics != null;
    }

    @Override
    public Vertx vertx() {
        return this.ctx.owner();
    }

    @Override
    public WorkerPool getPool() {
        return this.pool;
    }

    @Override
    public synchronized <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        if (this.closed) {
            throw new IllegalStateException("Worker executor closed");
        }
        ContextImpl context = (ContextImpl)this.ctx.owner().getOrCreateContext();
        context.executeBlocking(blockingCodeHandler, asyncResultHandler, this.pool.executor(), ordered ? context.orderedTasks : null, this.pool.metrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        WorkerExecutorImpl workerExecutorImpl = this;
        synchronized (workerExecutorImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.ctx.removeCloseHook(this);
        this.pool.release();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.close();
        completionHandler.handle(Future.succeededFuture());
    }
}

