/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.verticle;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import javax.tools.JavaFileObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.verticle.CustomJavaFileObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.URIDecoder;

public class PackageHelper {
    private static final String CLASS_FILE = ".class";
    private final ClassLoader classLoader;

    public PackageHelper(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<JavaFileObject> find(String packageName) throws IOException {
        String javaPackageName = packageName.replaceAll("\\.", "/");
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(javaPackageName);
        while (urlEnumeration.hasMoreElements()) {
            URL resource = urlEnumeration.nextElement();
            File directory = new File(URIDecoder.decodeURIComponent(resource.getFile(), false));
            if (directory.isDirectory()) {
                result.addAll(PackageHelper.browseDir(packageName, directory));
                continue;
            }
            result.addAll(PackageHelper.browseJar(resource));
        }
        return result;
    }

    private static List<JavaFileObject> browseDir(String packageName, File directory) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        for (File childFile : directory.listFiles()) {
            if (!childFile.isFile() || !childFile.getName().endsWith(CLASS_FILE)) continue;
            String binaryName = packageName + "." + childFile.getName().replaceAll(".class$", "");
            result.add(new CustomJavaFileObject(childFile.toURI(), JavaFileObject.Kind.CLASS, binaryName));
        }
        return result;
    }

    private static List<JavaFileObject> browseJar(URL packageFolderURL) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        try {
            String jarUri = packageFolderURL.toExternalForm().split("!")[0];
            JarURLConnection jarConn = (JarURLConnection)packageFolderURL.openConnection();
            String rootEntryName = jarConn.getEntryName();
            int rootEnd = rootEntryName.length() + 1;
            Enumeration<JarEntry> entryEnum = jarConn.getJarFile().entries();
            while (entryEnum.hasMoreElements()) {
                JarEntry jarEntry = entryEnum.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(rootEntryName) || name.indexOf(47, rootEnd) != -1 || !name.endsWith(CLASS_FILE)) continue;
                String binaryName = name.replaceAll("/", ".").replaceAll(".class$", "");
                result.add(new CustomJavaFileObject(URI.create(jarUri + "!/" + name), JavaFileObject.Kind.CLASS, binaryName));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(packageFolderURL + " is not a JAR file", e);
        }
        return result;
    }
}

