/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json;

import java.io.IOException;
import java.time.Instant;
import java.util.Base64;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonParser;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonProcessingException;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.DeserializationContext;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.JsonDeserializer;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.exc.InvalidFormatException;

class ByteArrayDeserializer
extends JsonDeserializer<byte[]> {
    ByteArrayDeserializer() {
    }

    @Override
    public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            return Base64.getDecoder().decode(text);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "Expected a base64 encoded byte array", (Object)text, Instant.class);
        }
    }
}

