/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonParser;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonProcessingException;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.DeserializationContext;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.JsonDeserializer;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.exc.InvalidFormatException;

class InstantDeserializer
extends JsonDeserializer<Instant> {
    InstantDeserializer() {
    }

    @Override
    public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(text));
        }
        catch (DateTimeException e) {
            throw new InvalidFormatException(p, "Expected an ISO 8601 formatted date time", (Object)text, Instant.class);
        }
    }
}

