/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json;

import java.time.Instant;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonParser;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.type.TypeReference;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.ObjectMapper;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.SerializationFeature;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.module.SimpleModule;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.ByteArrayDeserializer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.ByteArraySerializer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.DecodeException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.EncodeException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.InstantDeserializer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.InstantSerializer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArraySerializer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObjectSerializer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.jackson.JacksonCodec;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.json.JsonCodec;

public class Json {
    @Deprecated
    public static ObjectMapper mapper = new ObjectMapper();
    @Deprecated
    public static ObjectMapper prettyMapper = new ObjectMapper();

    private static void initialize() {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, new JsonObjectSerializer());
        module.addSerializer(JsonArray.class, new JsonArraySerializer());
        module.addSerializer(Instant.class, new InstantSerializer());
        module.addDeserializer(Instant.class, new InstantDeserializer());
        module.addSerializer(byte[].class, new ByteArraySerializer());
        module.addDeserializer(byte[].class, new ByteArrayDeserializer());
        mapper.registerModule(module);
        prettyMapper.registerModule(module);
    }

    public static String encode(Object obj) throws EncodeException {
        return JsonCodec.INSTANCE.toString(obj);
    }

    public static Buffer encodeToBuffer(Object obj) throws EncodeException {
        return JsonCodec.INSTANCE.toBuffer(obj);
    }

    public static String encodePrettily(Object obj) throws EncodeException {
        return JsonCodec.INSTANCE.toString(obj, true);
    }

    public static <T> T decodeValue(String str, Class<T> clazz) throws DecodeException {
        return JsonCodec.INSTANCE.fromString(str, clazz);
    }

    public static Object decodeValue(String str) throws DecodeException {
        return Json.decodeValue(str, Object.class);
    }

    @Deprecated
    public static <T> T decodeValue(String str, TypeReference<T> type) throws DecodeException {
        return JacksonCodec.fromString(str, type);
    }

    public static Object decodeValue(Buffer buf) throws DecodeException {
        return Json.decodeValue(buf, Object.class);
    }

    @Deprecated
    public static <T> T decodeValue(Buffer buf, TypeReference<T> type) throws DecodeException {
        return JacksonCodec.fromBuffer(buf, type);
    }

    public static <T> T decodeValue(Buffer buf, Class<T> clazz) throws DecodeException {
        return JsonCodec.INSTANCE.fromBuffer(buf, clazz);
    }

    static {
        Json.initialize();
    }
}

