/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.jackson;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonParser;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonToken;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.type.TypeReference;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.ObjectMapper;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBufInputStream;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.DecodeException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.EncodeException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.Json;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.json.JsonCodec;

public class JacksonCodec
implements JsonCodec {
    @Override
    public <T> T fromValue(Object json, Class<T> clazz) {
        Object value = Json.mapper.convertValue(json, clazz);
        if (clazz == Object.class) {
            value = JacksonCodec.adapt(value);
        }
        return value;
    }

    public static <T> T fromValue(Object json, TypeReference<T> type) {
        Object value = Json.mapper.convertValue(json, type);
        if (type.getType() == Object.class) {
            value = JacksonCodec.adapt(value);
        }
        return value;
    }

    @Override
    public <T> T fromString(String str, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(str), clazz);
    }

    public static <T> T fromString(String str, TypeReference<T> type) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(str), type);
    }

    @Override
    public <T> T fromBuffer(Buffer buf, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(buf), clazz);
    }

    public static <T> T fromBuffer(Buffer buf, TypeReference<T> type) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(buf), type);
    }

    private static JsonParser createParser(Buffer buf) {
        try {
            return Json.mapper.getFactory().createParser(new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static JsonParser createParser(String str) {
        try {
            return Json.mapper.getFactory().createParser(str);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static <T> T fromParser(JsonParser parser, Class<T> type) throws DecodeException {
        JsonToken remaining;
        Object value;
        try {
            value = Json.mapper.readValue(parser, type);
            remaining = parser.nextToken();
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
        finally {
            JacksonCodec.close(parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        if (type == Object.class) {
            value = JacksonCodec.adapt(value);
        }
        return value;
    }

    private static <T> T fromParser(JsonParser parser, TypeReference<T> type) throws DecodeException {
        JsonToken remaining;
        Object value;
        try {
            value = Json.mapper.readValue(parser, type);
            remaining = parser.nextToken();
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
        finally {
            JacksonCodec.close(parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        if (type.getType() == Object.class) {
            value = JacksonCodec.adapt(value);
        }
        return value;
    }

    private static void close(JsonParser parser) {
        try {
            parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Object adapt(Object o) {
        try {
            if (o instanceof List) {
                List list = (List)o;
                return new JsonArray(list);
            }
            if (o instanceof Map) {
                Map map = (Map)o;
                return new JsonObject(map);
            }
            return o;
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage());
        }
    }

    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper = pretty ? Json.prettyMapper : Json.mapper;
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper = pretty ? Json.prettyMapper : Json.mapper;
            return Buffer.buffer(mapper.writeValueAsBytes(object));
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static <T> T decodeValue(String str, TypeReference<T> type) throws DecodeException {
        return JacksonCodec.fromString(str, type);
    }

    public static <T> T decodeValue(Buffer buf, TypeReference<T> type) throws DecodeException {
        return JacksonCodec.fromBuffer(buf, type);
    }
}

