/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.JULLogDelegate;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.logging.LogDelegate;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.logging.LogDelegateFactory;

public class JULLogDelegateFactory
implements LogDelegateFactory {
    public static void loadConfig() {
        try (InputStream is = JULLogDelegateFactory.class.getClassLoader().getResourceAsStream("vertx-default-jul-logging.properties");){
            if (is != null) {
                LogManager.getLogManager().readConfiguration(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public LogDelegate createDelegate(String name) {
        return new JULLogDelegate(name);
    }

    static {
        if (System.getProperty("java.util.logging.config.file") == null) {
            JULLogDelegateFactory.loadConfig();
        }
    }
}

