/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.JULLogDelegateFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.logging.LogDelegate;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.logging.LogDelegateFactory;

public class LoggerFactory {
    public static final String LOGGER_DELEGATE_FACTORY_CLASS_NAME = "vertx.logger-delegate-factory-class-name";
    private static volatile LogDelegateFactory delegateFactory;
    private static final ConcurrentMap<String, Logger> loggers;

    public static synchronized void initialise() {
        LogDelegateFactory delegateFactory;
        String className = JULLogDelegateFactory.class.getName();
        try {
            className = System.getProperty(LOGGER_DELEGATE_FACTORY_CLASS_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (className != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clz = loader.loadClass(className);
                delegateFactory = (LogDelegateFactory)clz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error instantiating transformer class \"" + className + "\"", e);
            }
        } else {
            delegateFactory = new JULLogDelegateFactory();
        }
        LoggerFactory.delegateFactory = delegateFactory;
    }

    public static Logger getLogger(Class<?> clazz) {
        String name = clazz.isAnonymousClass() ? clazz.getEnclosingClass().getCanonicalName() : clazz.getCanonicalName();
        return LoggerFactory.getLogger(name);
    }

    public static Logger getLogger(String name) {
        LogDelegate delegate;
        Logger oldLogger;
        Logger logger = (Logger)loggers.get(name);
        if (logger == null && (oldLogger = loggers.putIfAbsent(name, logger = new Logger(delegate = delegateFactory.createDelegate(name)))) != null) {
            logger = oldLogger;
        }
        return logger;
    }

    public static void removeLogger(String name) {
        loggers.remove(name);
    }

    static {
        loggers = new ConcurrentHashMap<String, Logger>();
        LoggerFactory.initialise();
    }
}

