/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net;

import java.security.KeyStore;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.KeyCertOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.TrustOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.KeyStoreHelper;

public abstract class KeyStoreOptionsBase
implements KeyCertOptions,
TrustOptions {
    private KeyStoreHelper helper;
    private String provider;
    private String type;
    private String password;
    private String path;
    private Buffer value;

    protected KeyStoreOptionsBase() {
    }

    protected KeyStoreOptionsBase(KeyStoreOptionsBase other) {
        this.type = other.type;
        this.password = other.password;
        this.path = other.path;
        this.value = other.value;
    }

    protected String getType() {
        return this.type;
    }

    protected KeyStoreOptionsBase setType(String type) {
        this.type = type;
        return this;
    }

    protected String getProvider() {
        return this.provider;
    }

    protected KeyStoreOptionsBase setProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public KeyStoreOptionsBase setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public KeyStoreOptionsBase setPath(String path) {
        this.path = path;
        return this;
    }

    public Buffer getValue() {
        return this.value;
    }

    public KeyStoreOptionsBase setValue(Buffer value) {
        this.value = value;
        return this;
    }

    KeyStoreHelper getHelper(Vertx vertx) throws Exception {
        if (this.helper == null) {
            Supplier<Buffer> value;
            if (this.path != null) {
                value = () -> vertx.fileSystem().readFileBlocking(((VertxInternal)vertx).resolveFile(this.path).getAbsolutePath());
            } else if (this.value != null) {
                value = this::getValue;
            } else {
                return null;
            }
            this.helper = new KeyStoreHelper(KeyStoreHelper.loadKeyStoreOptions(this.type, this.provider, this.password, value), this.password);
        }
        return this.helper;
    }

    public KeyStore loadKeyStore(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.store() : null;
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.getKeyMgrFactory() : null;
    }

    @Override
    public Function<String, X509KeyManager> keyManagerMapper(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper::getKeyMgr : null;
    }

    @Override
    public TrustManagerFactory getTrustManagerFactory(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.getTrustMgrFactory((VertxInternal)vertx) : null;
    }

    @Override
    public Function<String, TrustManager[]> trustManagerMapper(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper::getTrustMgr : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        KeyStoreOptionsBase that = (KeyStoreOptionsBase)o;
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = 1;
        result += 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result += 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result += 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result += 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Override
    public KeyStoreOptionsBase copy() {
        return this.clone();
    }

    @Override
    public abstract KeyStoreOptionsBase clone();
}

