/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net;

import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.OpenSsl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.DataObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.OpenSSLEngineOptionsConverter;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SSLEngineOptions;

@DataObject(generateConverter=true, publicConverter=false)
public class OpenSSLEngineOptions
extends SSLEngineOptions {
    public static final boolean DEFAULT_SESSION_CACHE_ENABLED = true;
    private boolean sessionCacheEnabled;

    public static boolean isAvailable() {
        return OpenSsl.isAvailable();
    }

    public static boolean isAlpnAvailable() {
        return OpenSsl.isAlpnSupported();
    }

    public OpenSSLEngineOptions() {
        this.sessionCacheEnabled = true;
    }

    public OpenSSLEngineOptions(JsonObject json) {
        OpenSSLEngineOptionsConverter.fromJson(json, this);
    }

    public OpenSSLEngineOptions(OpenSSLEngineOptions other) {
        this.sessionCacheEnabled = other.isSessionCacheEnabled();
    }

    public OpenSSLEngineOptions setSessionCacheEnabled(boolean sessionCacheEnabled) {
        this.sessionCacheEnabled = sessionCacheEnabled;
        return this;
    }

    public boolean isSessionCacheEnabled() {
        return this.sessionCacheEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenSSLEngineOptions)) {
            return false;
        }
        OpenSSLEngineOptions that = (OpenSSLEngineOptions)o;
        return this.sessionCacheEnabled == that.sessionCacheEnabled;
    }

    public int hashCode() {
        return this.sessionCacheEnabled ? 1 : 0;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OpenSSLEngineOptionsConverter.toJson(this, json);
        return json;
    }

    @Override
    public OpenSSLEngineOptions clone() {
        return new OpenSSLEngineOptions(this);
    }

    @Override
    public OpenSSLEngineOptions copy() {
        return new OpenSSLEngineOptions(this);
    }
}

