/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.bootstrap.ServerBootstrap;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelFuture;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.GenericFutureListener;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.Promise;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;

public class AsyncResolveConnectHelper {
    private static void checkPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
    }

    public static Future<Channel> doBind(VertxInternal vertx, SocketAddress socketAddress, ServerBootstrap bootstrap) {
        Promise<Channel> promise = vertx.getAcceptorEventLoopGroup().next().newPromise();
        try {
            bootstrap.channelFactory(vertx.transport().serverChannelFactory(socketAddress.path() != null));
        }
        catch (Exception e) {
            promise.setFailure(e);
            return promise;
        }
        if (socketAddress.path() != null) {
            java.net.SocketAddress converted = vertx.transport().convert(socketAddress, true);
            ChannelFuture future = bootstrap.bind(converted);
            future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                if (f.isSuccess()) {
                    promise.setSuccess(future.channel());
                } else {
                    promise.setFailure(f.cause());
                }
            }));
        } else {
            AsyncResolveConnectHelper.checkPort(socketAddress.port());
            vertx.resolveAddress(socketAddress.host(), res -> {
                if (res.succeeded()) {
                    InetSocketAddress t = new InetSocketAddress((InetAddress)res.result(), socketAddress.port());
                    ChannelFuture future = bootstrap.bind(t);
                    future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                        if (f.isSuccess()) {
                            promise.setSuccess(future.channel());
                        } else {
                            promise.setFailure(f.cause());
                        }
                    }));
                } else {
                    promise.setFailure(res.cause());
                }
            });
        }
        return promise;
    }
}

