/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl;

import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.bootstrap.Bootstrap;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPipeline;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.logging.LoggingHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.stream.ChunkedWriteHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.timeout.IdleStateHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Closeable;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.ContextInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetClient;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetClientOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.ChannelProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.NetSocketImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.SSLHelper;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.VertxHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.Metrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.MetricsProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.TCPMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.VertxMetrics;

public class NetClientImpl
implements MetricsProvider,
NetClient {
    private static final Logger log = LoggerFactory.getLogger(NetClientImpl.class);
    protected final int idleTimeout;
    private final TimeUnit idleTimeoutUnit;
    protected final boolean logEnabled;
    private final VertxInternal vertx;
    private final NetClientOptions options;
    protected final SSLHelper sslHelper;
    private final Map<Channel, NetSocketImpl> socketMap = new ConcurrentHashMap<Channel, NetSocketImpl>();
    private final Closeable closeHook;
    private final ContextInternal creatingContext;
    private final TCPMetrics metrics;
    private volatile boolean closed;

    public NetClientImpl(VertxInternal vertx, NetClientOptions options) {
        this(vertx, options, true);
    }

    public NetClientImpl(VertxInternal vertx, NetClientOptions options, boolean useCreatingContext) {
        VertxMetrics metrics;
        this.vertx = vertx;
        this.options = new NetClientOptions(options);
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.closeHook = completionHandler -> {
            this.close();
            completionHandler.handle(Future.succeededFuture());
        };
        if (useCreatingContext) {
            this.creatingContext = vertx.getContext();
            if (this.creatingContext != null) {
                if (this.creatingContext.isMultiThreadedWorkerContext()) {
                    throw new IllegalStateException("Cannot use NetClient in a multi-threaded worker verticle");
                }
                this.creatingContext.addCloseHook(this.closeHook);
            }
        } else {
            this.creatingContext = null;
        }
        this.metrics = (metrics = vertx.metricsSPI()) != null ? metrics.createNetClientMetrics(options) : null;
        this.logEnabled = options.getLogActivity();
        this.idleTimeout = options.getIdleTimeout();
        this.idleTimeoutUnit = options.getIdleTimeoutUnit();
    }

    protected void initChannel(ChannelPipeline pipeline) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (this.sslHelper.isSSL()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.idleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0L, 0L, this.idleTimeout, this.idleTimeoutUnit));
        }
    }

    @Override
    public synchronized NetClient connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.connect(port, host, null, connectHandler);
        return this;
    }

    @Override
    public NetClient connect(int port, String host, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.doConnect(SocketAddress.inetSocketAddress(port, host), serverName, connectHandler);
        return this;
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (NetSocketImpl sock : this.socketMap.values()) {
                sock.close();
            }
            if (this.creatingContext != null) {
                this.creatingContext.removeCloseHook(this.closeHook);
            }
            this.closed = true;
            if (this.metrics != null) {
                this.metrics.close();
            }
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null && this.metrics.isEnabled();
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    private void applyConnectionOptions(boolean domainSocket, Bootstrap bootstrap) {
        this.vertx.transport().configure(this.options, domainSocket, bootstrap);
    }

    @Override
    public NetClient connect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.doConnect(remoteAddress, serverName, connectHandler);
        return this;
    }

    @Override
    public NetClient connect(SocketAddress remoteAddress, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.doConnect(remoteAddress, null, connectHandler);
        return this;
    }

    protected void doConnect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.doConnect(remoteAddress, serverName, connectHandler, this.options.getReconnectAttempts());
    }

    protected void doConnect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler, int remainingAttempts) {
        this.checkClosed();
        Objects.requireNonNull(connectHandler, "No null connectHandler accepted");
        ContextInternal context = this.vertx.getOrCreateContext();
        this.sslHelper.validate(this.vertx);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(context.nettyEventLoop());
        this.applyConnectionOptions(remoteAddress.path() != null, bootstrap);
        ChannelProvider channelProvider = new ChannelProvider(bootstrap, this.sslHelper, context, this.options.getProxyOptions());
        Handler<AsyncResult<Channel>> channelHandler = res -> {
            if (res.succeeded()) {
                Channel ch = (Channel)res.result();
                this.connected(context, ch, connectHandler, remoteAddress);
            } else {
                boolean connectError;
                Throwable cause = res.cause();
                boolean bl = connectError = cause instanceof ConnectException || cause instanceof FileNotFoundException;
                if (connectError && (remainingAttempts > 0 || remainingAttempts == -1)) {
                    context.executeFromIO(v -> {
                        log.debug("Failed to create connection. Will retry in " + this.options.getReconnectInterval() + " milliseconds");
                        this.vertx.setTimer(this.options.getReconnectInterval(), tid -> this.doConnect(remoteAddress, serverName, connectHandler, remainingAttempts == -1 ? remainingAttempts : remainingAttempts - 1));
                    });
                } else {
                    this.failed(context, null, cause, connectHandler);
                }
            }
        };
        SocketAddress peerAddress = remoteAddress;
        String peerHost = peerAddress.host();
        if (peerHost != null && peerHost.endsWith(".")) {
            peerAddress = SocketAddress.inetSocketAddress(peerAddress.port(), peerHost.substring(0, peerHost.length() - 1));
        }
        channelProvider.connect(remoteAddress, peerAddress, serverName, this.sslHelper.isSSL(), channelHandler);
    }

    private void connected(ContextInternal context, Channel ch, Handler<AsyncResult<NetSocket>> connectHandler, SocketAddress remoteAddress) {
        this.initChannel(ch.pipeline());
        VertxHandler<NetSocketImpl> handler = VertxHandler.create(context, ctx -> new NetSocketImpl(this.vertx, (ChannelHandlerContext)ctx, remoteAddress, context, this.sslHelper, this.metrics));
        handler.addHandler(sock -> {
            this.socketMap.put(ch, (NetSocketImpl)sock);
            context.executeFromIO(v -> {
                if (this.metrics != null) {
                    sock.metric(this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
                }
                sock.registerEventBusHandler();
                connectHandler.handle(Future.succeededFuture(sock));
            });
        });
        handler.removeHandler(conn -> this.socketMap.remove(ch));
        ch.pipeline().addLast("handler", handler);
    }

    private void failed(ContextInternal context, Channel ch, Throwable th, Handler<AsyncResult<NetSocket>> connectHandler) {
        if (ch != null) {
            ch.close();
        }
        context.runOnContext(v -> this.doFailed(connectHandler, th));
    }

    private void doFailed(Handler<AsyncResult<NetSocket>> connectHandler, Throwable th) {
        connectHandler.handle(Future.failedFuture(th));
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

