/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl;

import java.io.ByteArrayInputStream;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBufAllocator;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.ApplicationProtocolConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.DelegatingSslContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.OpenSsl;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.OpenSslServerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.OpenSslServerSessionContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.SslContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.SslContextBuilder;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.SslProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.Mapping;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.VertxException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.ClientAuth;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpClientOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpVersion;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.JdkSSLEngineOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.KeyCertOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetClientOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetServerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.OpenSSLEngineOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SSLEngineOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.TCPSSLOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.TrustOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.DefaultJDKCipherSuite;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.VertxTrustManagerFactory;

public class SSLHelper {
    private static final Map<HttpVersion, String> PROTOCOL_NAME_MAPPING = new EnumMap<HttpVersion, String>(HttpVersion.class);
    private static final Logger log;
    private boolean ssl;
    private boolean sni;
    private long sslHandshakeTimeout;
    private TimeUnit sslHandshakeTimeoutUnit;
    private KeyCertOptions keyCertOptions;
    private TrustOptions trustOptions;
    private boolean trustAll;
    private ArrayList<String> crlPaths;
    private ArrayList<Buffer> crlValues;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private Set<String> enabledCipherSuites;
    private boolean openSsl;
    private boolean client;
    private boolean useAlpn;
    private List<HttpVersion> applicationProtocols;
    private Set<String> enabledProtocols;
    private String endpointIdentificationAlgorithm = "";
    private SslContext sslContext;
    private Map<Certificate, SslContext> sslContextMap = new ConcurrentHashMap<Certificate, SslContext>();
    private boolean openSslSessionCacheEnabled = true;

    public static SSLEngineOptions resolveEngineOptions(TCPSSLOptions options) {
        SSLEngineOptions engineOptions = options.getSslEngineOptions();
        if (engineOptions == null && options.isUseAlpn()) {
            if (JdkSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new JdkSSLEngineOptions();
            } else if (OpenSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new OpenSSLEngineOptions();
            }
        }
        if (engineOptions == null) {
            engineOptions = new JdkSSLEngineOptions();
        } else if (engineOptions instanceof OpenSSLEngineOptions && !OpenSsl.isAvailable()) {
            VertxException ex = new VertxException("OpenSSL is not available");
            Throwable cause = OpenSsl.unavailabilityCause();
            if (cause != null) {
                ex.initCause(cause);
            }
            throw ex;
        }
        if (options.isUseAlpn()) {
            if (engineOptions instanceof JdkSSLEngineOptions && !JdkSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN not available for JDK SSL/TLS engine");
            }
            if (engineOptions instanceof OpenSSLEngineOptions && !OpenSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN is not available for OpenSSL SSL/TLS engine");
            }
        }
        return engineOptions;
    }

    public SSLHelper(HttpClientOptions options, KeyCertOptions keyCertOptions, TrustOptions trustOptions) {
        SSLEngineOptions sslEngineOptions = SSLHelper.resolveEngineOptions(options);
        this.ssl = options.isSsl();
        this.sslHandshakeTimeout = options.getSslHandshakeTimeout();
        this.sslHandshakeTimeoutUnit = options.getSslHandshakeTimeoutUnit();
        this.keyCertOptions = keyCertOptions;
        this.trustOptions = trustOptions;
        this.trustAll = options.isTrustAll();
        this.crlPaths = new ArrayList<String>(options.getCrlPaths());
        this.crlValues = new ArrayList<Buffer>(options.getCrlValues());
        this.enabledCipherSuites = options.getEnabledCipherSuites();
        this.openSsl = sslEngineOptions instanceof OpenSSLEngineOptions;
        this.client = true;
        this.useAlpn = options.isUseAlpn();
        this.enabledProtocols = options.getEnabledSecureTransportProtocols();
        if (options.isVerifyHost()) {
            this.endpointIdentificationAlgorithm = "HTTPS";
        }
        this.openSslSessionCacheEnabled = sslEngineOptions instanceof OpenSSLEngineOptions && ((OpenSSLEngineOptions)sslEngineOptions).isSessionCacheEnabled();
    }

    public SSLHelper(HttpServerOptions options, KeyCertOptions keyCertOptions, TrustOptions trustOptions) {
        SSLEngineOptions sslEngineOptions = SSLHelper.resolveEngineOptions(options);
        this.ssl = options.isSsl();
        this.sslHandshakeTimeout = options.getSslHandshakeTimeout();
        this.sslHandshakeTimeoutUnit = options.getSslHandshakeTimeoutUnit();
        this.keyCertOptions = keyCertOptions;
        this.trustOptions = trustOptions;
        this.clientAuth = options.getClientAuth();
        this.crlPaths = options.getCrlPaths() != null ? new ArrayList<String>(options.getCrlPaths()) : null;
        this.crlValues = options.getCrlValues() != null ? new ArrayList<Buffer>(options.getCrlValues()) : null;
        this.enabledCipherSuites = options.getEnabledCipherSuites();
        this.openSsl = sslEngineOptions instanceof OpenSSLEngineOptions;
        this.client = false;
        this.useAlpn = options.isUseAlpn();
        this.enabledProtocols = options.getEnabledSecureTransportProtocols();
        this.openSslSessionCacheEnabled = sslEngineOptions instanceof OpenSSLEngineOptions && ((OpenSSLEngineOptions)sslEngineOptions).isSessionCacheEnabled();
        this.sni = options.isSni();
    }

    public SSLHelper(NetClientOptions options, KeyCertOptions keyCertOptions, TrustOptions trustOptions) {
        SSLEngineOptions sslEngineOptions = SSLHelper.resolveEngineOptions(options);
        this.ssl = options.isSsl();
        this.sslHandshakeTimeout = options.getSslHandshakeTimeout();
        this.sslHandshakeTimeoutUnit = options.getSslHandshakeTimeoutUnit();
        this.keyCertOptions = keyCertOptions;
        this.trustOptions = trustOptions;
        this.trustAll = options.isTrustAll();
        this.crlPaths = new ArrayList<String>(options.getCrlPaths());
        this.crlValues = new ArrayList<Buffer>(options.getCrlValues());
        this.enabledCipherSuites = options.getEnabledCipherSuites();
        this.openSsl = sslEngineOptions instanceof OpenSSLEngineOptions;
        this.client = true;
        this.useAlpn = false;
        this.enabledProtocols = options.getEnabledSecureTransportProtocols();
        this.endpointIdentificationAlgorithm = options.getHostnameVerificationAlgorithm();
        this.openSslSessionCacheEnabled = sslEngineOptions instanceof OpenSSLEngineOptions && ((OpenSSLEngineOptions)sslEngineOptions).isSessionCacheEnabled();
    }

    public SSLHelper(NetServerOptions options, KeyCertOptions keyCertOptions, TrustOptions trustOptions) {
        SSLEngineOptions sslEngineOptions = SSLHelper.resolveEngineOptions(options);
        this.ssl = options.isSsl();
        this.sslHandshakeTimeout = options.getSslHandshakeTimeout();
        this.sslHandshakeTimeoutUnit = options.getSslHandshakeTimeoutUnit();
        this.keyCertOptions = keyCertOptions;
        this.trustOptions = trustOptions;
        this.clientAuth = options.getClientAuth();
        this.crlPaths = options.getCrlPaths() != null ? new ArrayList<String>(options.getCrlPaths()) : null;
        this.crlValues = options.getCrlValues() != null ? new ArrayList<Buffer>(options.getCrlValues()) : null;
        this.enabledCipherSuites = options.getEnabledCipherSuites();
        this.openSsl = sslEngineOptions instanceof OpenSSLEngineOptions;
        this.client = false;
        this.useAlpn = false;
        this.enabledProtocols = options.getEnabledSecureTransportProtocols();
        this.openSslSessionCacheEnabled = options.getSslEngineOptions() instanceof OpenSSLEngineOptions && ((OpenSSLEngineOptions)options.getSslEngineOptions()).isSessionCacheEnabled();
        this.sni = options.isSni();
    }

    public SSLHelper(SSLHelper that) {
        this.ssl = that.ssl;
        this.sni = that.sni;
        this.sslHandshakeTimeout = that.sslHandshakeTimeout;
        this.sslHandshakeTimeoutUnit = that.sslHandshakeTimeoutUnit;
        this.keyCertOptions = that.keyCertOptions;
        this.trustOptions = that.trustOptions;
        this.trustAll = that.trustAll;
        this.crlPaths = that.crlPaths;
        this.crlValues = that.crlValues;
        this.clientAuth = that.clientAuth;
        this.enabledCipherSuites = that.enabledCipherSuites;
        this.openSsl = that.openSsl;
        this.client = that.client;
        this.useAlpn = that.useAlpn;
        this.applicationProtocols = that.applicationProtocols;
        this.enabledProtocols = that.enabledProtocols;
        this.endpointIdentificationAlgorithm = that.endpointIdentificationAlgorithm;
        this.openSslSessionCacheEnabled = that.openSslSessionCacheEnabled;
    }

    public boolean isUseAlpn() {
        return this.useAlpn;
    }

    public SSLHelper setUseAlpn(boolean useAlpn) {
        this.useAlpn = useAlpn;
        return this;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public boolean isSNI() {
        return this.sni;
    }

    public long getSslHandshakeTimeout() {
        return this.sslHandshakeTimeout;
    }

    public TimeUnit getSslHandshakeTimeoutUnit() {
        return this.sslHandshakeTimeoutUnit;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public List<HttpVersion> getApplicationProtocols() {
        return this.applicationProtocols;
    }

    public SSLHelper setApplicationProtocols(List<HttpVersion> applicationProtocols) {
        this.applicationProtocols = applicationProtocols;
        return this;
    }

    private SslContext createContext(VertxInternal vertx, X509KeyManager mgr, TrustManagerFactory trustMgrFactory) {
        try {
            SSLSessionContext sslSessionContext;
            SslContext ctx;
            KeyManagerFactory keyMgrFactory;
            SslContextBuilder builder;
            if (this.client) {
                builder = SslContextBuilder.forClient();
                keyMgrFactory = this.getKeyMgrFactory(vertx);
                if (keyMgrFactory != null) {
                    builder.keyManager(keyMgrFactory);
                }
            } else if (mgr != null) {
                builder = SslContextBuilder.forServer(mgr.getPrivateKey(null), null, mgr.getCertificateChain(null));
            } else {
                keyMgrFactory = this.getKeyMgrFactory(vertx);
                if (keyMgrFactory == null) {
                    throw new VertxException("Key/certificate is mandatory for SSL");
                }
                builder = SslContextBuilder.forServer(keyMgrFactory);
            }
            Collection<String> cipherSuites = this.enabledCipherSuites;
            if (this.openSsl) {
                builder.sslProvider(SslProvider.OPENSSL);
                if (cipherSuites == null || cipherSuites.isEmpty()) {
                    cipherSuites = OpenSsl.availableOpenSslCipherSuites();
                }
            } else {
                builder.sslProvider(SslProvider.JDK);
                if (cipherSuites == null || cipherSuites.isEmpty()) {
                    cipherSuites = DefaultJDKCipherSuite.get();
                }
            }
            if (trustMgrFactory != null) {
                builder.trustManager(trustMgrFactory);
            }
            if (cipherSuites != null && cipherSuites.size() > 0) {
                builder.ciphers(cipherSuites);
            }
            if (this.useAlpn && this.applicationProtocols != null && this.applicationProtocols.size() > 0) {
                builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, this.applicationProtocols.stream().map(PROTOCOL_NAME_MAPPING::get).collect(Collectors.toList())));
            }
            if ((ctx = builder.build()) instanceof OpenSslServerContext && (sslSessionContext = ctx.sessionContext()) instanceof OpenSslServerSessionContext) {
                ((OpenSslServerSessionContext)sslSessionContext).setSessionCacheEnabled(this.openSslSessionCacheEnabled);
            }
            return ctx;
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    private KeyManagerFactory getKeyMgrFactory(VertxInternal vertx) throws Exception {
        return this.keyCertOptions == null ? null : this.keyCertOptions.getKeyManagerFactory(vertx);
    }

    private TrustManagerFactory getTrustMgrFactory(VertxInternal vertx, String serverName) throws Exception {
        TrustManager[] mgrs;
        block14: {
            block15: {
                mgrs = null;
                if (this.trustAll) {
                    mgrs = new TrustManager[]{SSLHelper.createTrustAllTrustManager()};
                } else if (this.trustOptions != null) {
                    if (serverName != null) {
                        TrustManagerFactory fact;
                        Function<String, TrustManager[]> mapper = this.trustOptions.trustManagerMapper(vertx);
                        if (mapper != null) {
                            mgrs = mapper.apply(serverName);
                        }
                        if (mgrs == null && (fact = this.trustOptions.getTrustManagerFactory(vertx)) != null) {
                            mgrs = fact.getTrustManagers();
                        }
                    } else {
                        TrustManagerFactory fact = this.trustOptions.getTrustManagerFactory(vertx);
                        if (fact != null) {
                            mgrs = fact.getTrustManagers();
                        }
                    }
                }
                if (mgrs == null) {
                    return null;
                }
                if (this.crlPaths == null || this.crlValues == null) break block14;
                if (this.crlPaths.size() > 0) break block15;
                if (this.crlValues.size() <= 0) break block14;
            }
            Stream<Buffer> tmp = this.crlPaths.stream().map(path -> vertx.resolveFile((String)path).getAbsolutePath()).map(vertx.fileSystem()::readFileBlocking);
            tmp = Stream.concat(tmp, this.crlValues.stream());
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            ArrayList<CRL> crls = new ArrayList<CRL>();
            for (Buffer crlValue : tmp.collect(Collectors.toList())) {
                crls.addAll(certificatefactory.generateCRLs(new ByteArrayInputStream(crlValue.getBytes())));
            }
            mgrs = SSLHelper.createUntrustRevokedCertTrustManager(mgrs, crls);
        }
        return new VertxTrustManagerFactory(mgrs);
    }

    private static TrustManager[] createUntrustRevokedCertTrustManager(TrustManager[] trustMgrs, final ArrayList<CRL> crls) {
        trustMgrs = (TrustManager[])trustMgrs.clone();
        for (int i = 0; i < trustMgrs.length; ++i) {
            TrustManager trustMgr = trustMgrs[i];
            if (!(trustMgr instanceof X509TrustManager)) continue;
            final X509TrustManager x509TrustManager = (X509TrustManager)trustMgr;
            trustMgrs[i] = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkClientTrusted(x509Certificates, s2);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkServerTrusted(x509Certificates, s2);
                }

                private void checkRevoked(X509Certificate[] x509Certificates) throws CertificateException {
                    for (X509Certificate cert : x509Certificates) {
                        for (CRL crl : crls) {
                            if (!crl.isRevoked(cert)) continue;
                            throw new CertificateException("Certificate revoked");
                        }
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return x509TrustManager.getAcceptedIssuers();
                }
            };
        }
        return trustMgrs;
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public Mapping<? super String, ? extends SslContext> serverNameMapper(VertxInternal vertx) {
        return serverName -> {
            SslContext ctx = this.getContext(vertx, (String)serverName);
            if (ctx != null) {
                ctx = new DelegatingSslContext(ctx, (String)serverName){
                    final /* synthetic */ String val$serverName;
                    {
                        this.val$serverName = string;
                        super(x0);
                    }

                    @Override
                    protected void initEngine(SSLEngine engine) {
                        SSLHelper.this.configureEngine(engine, this.val$serverName);
                    }
                };
            }
            return ctx;
        };
    }

    public void configureEngine(SSLEngine engine, String serverName) {
        SSLParameters sslParameters;
        if (this.enabledCipherSuites != null && !this.enabledCipherSuites.isEmpty()) {
            String[] toUse = this.enabledCipherSuites.toArray(new String[this.enabledCipherSuites.size()]);
            engine.setEnabledCipherSuites(toUse);
        }
        engine.setUseClientMode(this.client);
        LinkedHashSet<String> protocols = new LinkedHashSet<String>(this.enabledProtocols);
        protocols.retainAll(Arrays.asList(engine.getSupportedProtocols()));
        if (protocols.isEmpty()) {
            log.warn("no SSL/TLS protocols are enabled due to configuration restrictions");
        }
        engine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        if (!this.client) {
            switch (this.getClientAuth()) {
                case REQUEST: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    engine.setNeedClientAuth(false);
                }
            }
        } else if (!this.endpointIdentificationAlgorithm.isEmpty()) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
            engine.setSSLParameters(sslParameters);
        }
        if (serverName != null) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setServerNames(Collections.singletonList(new SNIHostName(serverName)));
            engine.setSSLParameters(sslParameters);
        }
    }

    public SslContext getContext(VertxInternal vertx) {
        return this.getContext(vertx, null);
    }

    public SslContext getContext(VertxInternal vertx, String serverName) {
        X509KeyManager mgr;
        if (serverName == null) {
            if (this.sslContext == null) {
                TrustManagerFactory trustMgrFactory = null;
                try {
                    trustMgrFactory = this.getTrustMgrFactory(vertx, null);
                }
                catch (Exception e) {
                    throw new VertxException(e);
                }
                this.sslContext = this.createContext(vertx, null, trustMgrFactory);
            }
            return this.sslContext;
        }
        try {
            mgr = this.keyCertOptions.keyManagerMapper(vertx).apply(serverName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (mgr == null) {
            return this.sslContext;
        }
        try {
            TrustManagerFactory trustMgrFactory = this.getTrustMgrFactory(vertx, serverName);
            return this.sslContextMap.computeIfAbsent(mgr.getCertificateChain(null)[0], s2 -> this.createContext(vertx, mgr, trustMgrFactory));
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public synchronized void validate(VertxInternal vertx) {
        if (this.ssl) {
            this.getContext(vertx, null);
        }
    }

    public SSLEngine createEngine(SslContext sslContext) {
        SSLEngine engine = sslContext.newEngine(ByteBufAllocator.DEFAULT);
        this.configureEngine(engine, null);
        return engine;
    }

    public SSLEngine createEngine(VertxInternal vertx, SocketAddress socketAddress, String serverName) {
        SslContext context = this.getContext(vertx, null);
        SSLEngine engine = socketAddress.path() != null ? context.newEngine(ByteBufAllocator.DEFAULT) : context.newEngine(ByteBufAllocator.DEFAULT, socketAddress.host(), socketAddress.port());
        this.configureEngine(engine, serverName);
        return engine;
    }

    public SSLEngine createEngine(VertxInternal vertx, String host, int port, boolean forceSNI) {
        SSLEngine engine = this.getContext(vertx, null).newEngine(ByteBufAllocator.DEFAULT, host, port);
        this.configureEngine(engine, forceSNI ? host : null);
        return engine;
    }

    public SSLEngine createEngine(VertxInternal vertx, String host, int port) {
        SSLEngine engine = this.getContext(vertx, null).newEngine(ByteBufAllocator.DEFAULT, host, port);
        this.configureEngine(engine, null);
        return engine;
    }

    public SSLEngine createEngine(VertxInternal vertx) {
        SSLEngine engine = this.getContext(vertx, null).newEngine(ByteBufAllocator.DEFAULT);
        this.configureEngine(engine, null);
        return engine;
    }

    static {
        PROTOCOL_NAME_MAPPING.put(HttpVersion.HTTP_2, "h2");
        PROTOCOL_NAME_MAPPING.put(HttpVersion.HTTP_1_1, "http/1.1");
        PROTOCOL_NAME_MAPPING.put(HttpVersion.HTTP_1_0, "http/1.0");
        log = LoggerFactory.getLogger(SSLHelper.class);
    }
}

