/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelInboundHandlerAdapter;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.SniCompletionEvent;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ssl.SslHandshakeCompletionEvent;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.Attribute;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.AttributeKey;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;

public class SslHandshakeCompletionHandler
extends ChannelInboundHandlerAdapter {
    static AttributeKey<String> SERVER_NAME_ATTR = AttributeKey.valueOf("sniServerName");
    private final Handler<AsyncResult<Channel>> handler;

    public SslHandshakeCompletionHandler(Handler<AsyncResult<Channel>> handler) {
        this.handler = handler;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof SniCompletionEvent) {
            SniCompletionEvent completion = (SniCompletionEvent)evt;
            Attribute<String> val = ctx.channel().attr(SERVER_NAME_ATTR);
            val.set(completion.hostname());
        } else if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent completion = (SslHandshakeCompletionEvent)evt;
            if (completion.isSuccess()) {
                ctx.pipeline().remove(this);
                this.handler.handle(Future.succeededFuture(ctx.channel()));
            } else {
                this.handler.handle(Future.failedFuture(completion.cause()));
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }
}

