/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.transport;

import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.bootstrap.Bootstrap;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.bootstrap.ServerBootstrap;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.EventLoopGroup;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ServerChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.epoll.Epoll;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.epoll.EpollChannelOption;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.epoll.EpollDatagramChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.epoll.EpollDomainSocketChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.epoll.EpollEventLoopGroup;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.epoll.EpollServerDomainSocketChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.epoll.EpollServerSocketChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.epoll.EpollSocketChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.socket.DatagramChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.socket.InternetProtocolFamily;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.unix.DomainSocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.datagram.DatagramSocketOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.ClientOptionsBase;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetServerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.SocketAddressImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.transport.Transport;

class EpollTransport
extends Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    EpollTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            return new DomainSocketAddress(address.path());
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return Epoll.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return Epoll.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new EpollDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new EpollDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollDomainSocketChannel::new;
        }
        return EpollSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollServerDomainSocketChannel::new;
        }
        return EpollServerSocketChannel::new;
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
        super.configure(channel, options);
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
            if (options.isTcpFastOpen()) {
                bootstrap.option(EpollChannelOption.TCP_FASTOPEN, options.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0);
            }
            bootstrap.childOption(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
            bootstrap.childOption(EpollChannelOption.TCP_CORK, options.isTcpCork());
        }
        super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(ClientOptionsBase options, boolean domainSocket, Bootstrap bootstrap) {
        if (!domainSocket) {
            if (options.isTcpFastOpen()) {
                bootstrap.option(EpollChannelOption.TCP_FASTOPEN_CONNECT, options.isTcpFastOpen());
            }
            bootstrap.option(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
            bootstrap.option(EpollChannelOption.TCP_CORK, options.isTcpCork());
        }
        super.configure(options, domainSocket, bootstrap);
    }
}

