/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.transport;

import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.bootstrap.ServerBootstrap;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.EventLoopGroup;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ServerChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.kqueue.KQueue;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.kqueue.KQueueChannelOption;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.kqueue.KQueueDatagramChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.kqueue.KQueueDomainSocketChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.kqueue.KQueueEventLoopGroup;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.kqueue.KQueueServerSocketChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.kqueue.KQueueSocketChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.socket.DatagramChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.socket.InternetProtocolFamily;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.unix.DomainSocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.datagram.DatagramSocketOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetServerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.SocketAddressImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.transport.Transport;

class KQueueTransport
extends Transport {
    KQueueTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            return new DomainSocketAddress(address.path());
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return KQueue.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return KQueue.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        KQueueEventLoopGroup eventLoopGroup = new KQueueEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new KQueueDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new KQueueDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueDomainSocketChannel::new;
        }
        return KQueueSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueServerDomainSocketChannel::new;
        }
        return KQueueServerSocketChannel::new;
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        }
        super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        super.configure(channel, options);
    }
}

