/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.parsetools.impl;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.type.TypeReference;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.util.TokenBuffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.DecodeException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.Json;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.jackson.JacksonCodec;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.parsetools.JsonEvent;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.parsetools.JsonEventType;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.json.JsonCodec;

public class JsonEventImpl
implements JsonEvent {
    private final JsonEventType type;
    private final String field;
    private final Object value;
    private final TokenBuffer buffer;

    public JsonEventImpl(JsonEventType type, String field, Object value) {
        this(type, field, value, null);
    }

    public JsonEventImpl(JsonEventType type, String field, Object value, TokenBuffer buffer) {
        this.type = type;
        this.field = field;
        this.value = value;
        this.buffer = buffer;
    }

    @Override
    public JsonEventType type() {
        return this.type;
    }

    @Override
    public String fieldName() {
        return this.field;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public boolean isNumber() {
        return this.value instanceof Number;
    }

    @Override
    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public boolean isNull() {
        return this.type == JsonEventType.VALUE && this.value == null;
    }

    @Override
    public boolean isObject() {
        return this.value instanceof JsonObject;
    }

    @Override
    public boolean isArray() {
        return this.value instanceof JsonArray;
    }

    @Override
    public <T> T mapTo(Class<T> type) {
        if (this.buffer != null) {
            try {
                return Json.mapper.readValue(this.buffer.asParser(), type);
            }
            catch (Exception e) {
                throw new DecodeException(e.getMessage());
            }
        }
        return JsonCodec.INSTANCE.fromValue(this.value, type);
    }

    @Override
    public <T> T mapTo(TypeReference<T> type) {
        if (this.buffer != null) {
            try {
                return Json.mapper.readValue(this.buffer.asParser(), type);
            }
            catch (Exception e) {
                throw new DecodeException(e.getMessage());
            }
        }
        return JacksonCodec.fromValue(this.value, type);
    }

    @Override
    public Integer integerValue() {
        if (this.value != null) {
            Number number = (Number)this.value;
            if (this.value instanceof Integer) {
                return (Integer)this.value;
            }
            return number.intValue();
        }
        return null;
    }

    @Override
    public Long longValue() {
        if (this.value != null) {
            Number number = (Number)this.value;
            if (this.value instanceof Integer) {
                return (Long)this.value;
            }
            return number.longValue();
        }
        return null;
    }

    @Override
    public Float floatValue() {
        if (this.value != null) {
            Number number = (Number)this.value;
            if (this.value instanceof Float) {
                return (Float)this.value;
            }
            return Float.valueOf(number.floatValue());
        }
        return null;
    }

    @Override
    public Double doubleValue() {
        if (this.value != null) {
            Number number = (Number)this.value;
            if (this.value instanceof Double) {
                return (Double)this.value;
            }
            return number.doubleValue();
        }
        return null;
    }

    @Override
    public Boolean booleanValue() {
        return (Boolean)this.value;
    }

    @Override
    public String stringValue() {
        return (String)this.value;
    }

    @Override
    public Buffer binaryValue() {
        return this.value != null ? Buffer.buffer(Base64.getDecoder().decode((String)this.value)) : null;
    }

    @Override
    public Instant instantValue() {
        return this.value != null ? Instant.from(DateTimeFormatter.ISO_INSTANT.parse((CharSequence)this.value)) : null;
    }

    @Override
    public JsonObject objectValue() {
        return (JsonObject)this.value;
    }

    @Override
    public JsonArray arrayValue() {
        return (JsonArray)this.value;
    }
}

