/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.parsetools.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonToken;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.json.async.NonBlockingJsonParser;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.util.TokenBuffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.VertxException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.Arguments;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.DecodeException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.Json;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.parsetools.JsonEvent;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.parsetools.JsonEventType;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.parsetools.JsonParser;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.parsetools.impl.JsonEventImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.streams.ReadStream;

public class JsonParserImpl
implements JsonParser {
    private NonBlockingJsonParser parser;
    private JsonToken currentToken;
    private Handler<JsonToken> tokenHandler = this::handleToken;
    private Handler<JsonEvent> eventHandler;
    private BufferingHandler arrayHandler;
    private BufferingHandler objectHandler;
    private Handler<Throwable> exceptionHandler;
    private String currentField;
    private Handler<Void> endHandler;
    private long demand = Long.MAX_VALUE;
    private boolean ended;
    private final ReadStream<Buffer> stream;

    public JsonParserImpl(ReadStream<Buffer> stream) {
        this.stream = stream;
        JsonFactory factory = new JsonFactory();
        try {
            this.parser = (NonBlockingJsonParser)factory.createNonBlockingByteArrayParser();
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    @Override
    public JsonParser pause() {
        this.demand = 0L;
        return this;
    }

    @Override
    public JsonParser resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public JsonParser fetch(long amount) {
        Arguments.require(amount > 0L, "Fetch amount must be > 0L");
        this.demand += amount;
        if (this.demand < 0L) {
            this.demand = Long.MAX_VALUE;
        }
        this.checkPending();
        return this;
    }

    @Override
    public JsonParser endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public JsonParser handler(Handler<JsonEvent> handler) {
        this.eventHandler = handler;
        if (this.stream != null) {
            if (handler != null) {
                this.stream.endHandler((Void v) -> this.end());
                this.stream.exceptionHandler(err -> {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Throwable)err);
                    }
                });
                this.stream.handler(this);
            } else {
                this.stream.handler(null);
                this.stream.endHandler(null);
                this.stream.exceptionHandler((Handler)null);
            }
        }
        return this;
    }

    private void handleEvent(JsonEvent event) {
        Handler<JsonEvent> handler;
        if (this.demand != Long.MAX_VALUE) {
            --this.demand;
        }
        if ((handler = this.eventHandler) != null) {
            handler.handle(event);
        }
    }

    private void handleToken(JsonToken token) {
        try {
            switch (token) {
                case START_OBJECT: {
                    BufferingHandler handler = this.objectHandler;
                    if (handler != null) {
                        this.tokenHandler = handler;
                        handler.handle(token);
                        break;
                    }
                    this.handleEvent(new JsonEventImpl(JsonEventType.START_OBJECT, this.currentField, null));
                    break;
                }
                case START_ARRAY: {
                    BufferingHandler handler = this.arrayHandler;
                    if (handler != null) {
                        this.tokenHandler = handler;
                        handler.handle(token);
                        break;
                    }
                    this.handleEvent(new JsonEventImpl(JsonEventType.START_ARRAY, this.currentField, null));
                    break;
                }
                case FIELD_NAME: {
                    this.currentField = this.parser.getCurrentName();
                    break;
                }
                case VALUE_STRING: {
                    String f = this.currentField;
                    this.currentField = null;
                    this.handleEvent(new JsonEventImpl(JsonEventType.VALUE, f, this.parser.getText()));
                    break;
                }
                case VALUE_TRUE: {
                    this.handleEvent(new JsonEventImpl(JsonEventType.VALUE, this.currentField, Boolean.TRUE));
                    break;
                }
                case VALUE_FALSE: {
                    this.handleEvent(new JsonEventImpl(JsonEventType.VALUE, this.currentField, Boolean.FALSE));
                    break;
                }
                case VALUE_NULL: {
                    this.handleEvent(new JsonEventImpl(JsonEventType.VALUE, this.currentField, null));
                    break;
                }
                case VALUE_NUMBER_INT: {
                    this.handleEvent(new JsonEventImpl(JsonEventType.VALUE, this.currentField, this.parser.getLongValue()));
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    this.handleEvent(new JsonEventImpl(JsonEventType.VALUE, this.currentField, this.parser.getDoubleValue()));
                    break;
                }
                case END_OBJECT: {
                    this.handleEvent(new JsonEventImpl(JsonEventType.END_OBJECT, null, null));
                    break;
                }
                case END_ARRAY: {
                    this.handleEvent(new JsonEventImpl(JsonEventType.END_ARRAY, null, null));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Token " + (Object)((Object)token) + " not implemented");
                }
            }
        }
        catch (IOException e) {
            throw new DecodeException(e.getMessage());
        }
    }

    @Override
    public void handle(Buffer event) {
        byte[] bytes = event.getBytes();
        try {
            this.parser.feedInput(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(e);
                return;
            }
            throw new DecodeException(e.getMessage(), e);
        }
        this.checkPending();
    }

    @Override
    public void end() {
        if (this.ended) {
            throw new IllegalStateException("Parsing already done");
        }
        this.ended = true;
        this.parser.endOfInput();
        this.checkPending();
    }

    private void checkPending() {
        try {
            while (true) {
                JsonToken next;
                if (this.currentToken == null && (next = this.parser.nextToken()) != null && next != JsonToken.NOT_AVAILABLE) {
                    this.currentToken = next;
                }
                if (this.currentToken == null) {
                    if (!this.ended) break;
                    if (this.endHandler != null) {
                        this.endHandler.handle(null);
                    }
                    return;
                }
                if (this.demand <= 0L) break;
                JsonToken token = this.currentToken;
                this.currentToken = null;
                this.tokenHandler.handle(token);
            }
            if (this.demand == 0L) {
                if (this.stream != null) {
                    this.stream.pause();
                }
            } else if (this.stream != null) {
                this.stream.resume();
            }
        }
        catch (IOException e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(e);
            }
            throw new DecodeException(e.getMessage());
        }
        catch (Exception e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(e);
            }
            throw e;
        }
    }

    @Override
    public JsonParser objectEventMode() {
        if (this.objectHandler != null) {
            this.objectHandler = null;
            this.tokenHandler = this::handleToken;
        }
        return this;
    }

    @Override
    public JsonParser objectValueMode() {
        if (this.objectHandler == null) {
            BufferingHandler handler = new BufferingHandler();
            handler.handler = buffer -> this.handleEvent(new JsonEventImpl(JsonEventType.VALUE, this.currentField, new JsonObject(handler.convert(Map.class)), handler.buffer));
            this.objectHandler = handler;
        }
        return this;
    }

    @Override
    public JsonParser arrayEventMode() {
        if (this.arrayHandler != null) {
            this.arrayHandler = null;
            this.tokenHandler = this::handleToken;
        }
        return this;
    }

    @Override
    public JsonParser arrayValueMode() {
        if (this.arrayHandler == null) {
            BufferingHandler handler = new BufferingHandler();
            handler.handler = buffer -> this.handleEvent(new JsonEventImpl(JsonEventType.VALUE, this.currentField, new JsonArray(handler.convert(List.class)), handler.buffer));
            this.arrayHandler = handler;
        }
        return this;
    }

    @Override
    public JsonParser write(Buffer buffer) {
        this.handle(buffer);
        return this;
    }

    @Override
    public JsonParser exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private class BufferingHandler
    implements Handler<JsonToken> {
        Handler<Void> handler;
        int depth;
        TokenBuffer buffer;

        private BufferingHandler() {
        }

        @Override
        public void handle(JsonToken event) {
            try {
                switch (event) {
                    case START_OBJECT: 
                    case START_ARRAY: {
                        if (this.depth++ == 0) {
                            this.buffer = new TokenBuffer(Json.mapper, false);
                        }
                        if (event == JsonToken.START_OBJECT) {
                            this.buffer.writeStartObject();
                            break;
                        }
                        this.buffer.writeStartArray();
                        break;
                    }
                    case FIELD_NAME: {
                        this.buffer.writeFieldName(JsonParserImpl.this.parser.getCurrentName());
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        this.buffer.writeNumber(JsonParserImpl.this.parser.getLongValue());
                        break;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        this.buffer.writeNumber(JsonParserImpl.this.parser.getDoubleValue());
                        break;
                    }
                    case VALUE_STRING: {
                        this.buffer.writeString(JsonParserImpl.this.parser.getText());
                        break;
                    }
                    case VALUE_TRUE: {
                        this.buffer.writeBoolean(true);
                        break;
                    }
                    case VALUE_FALSE: {
                        this.buffer.writeBoolean(false);
                        break;
                    }
                    case VALUE_NULL: {
                        this.buffer.writeNull();
                        break;
                    }
                    case END_OBJECT: 
                    case END_ARRAY: {
                        if (event == JsonToken.END_OBJECT) {
                            this.buffer.writeEndObject();
                        } else {
                            this.buffer.writeEndArray();
                        }
                        if (--this.depth == 0) {
                            JsonParserImpl.this.tokenHandler = x$0 -> JsonParserImpl.this.handleToken(x$0);
                            this.buffer.flush();
                            this.handler.handle(null);
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not implemented " + (Object)((Object)event));
                    }
                }
            }
            catch (IOException e) {
                throw new VertxException(e);
            }
        }

        <T> T convert(Class<T> type) {
            try {
                return Json.mapper.readValue(this.buffer.asParser(), type);
            }
            catch (Exception e) {
                throw new DecodeException(e.getMessage());
            }
        }
    }
}

