/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.impl;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.ContextInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.Counter;

public class AsynchronousCounter
implements Counter {
    private final VertxInternal vertx;
    private final AtomicLong counter;

    public AsynchronousCounter(VertxInternal vertx) {
        this.vertx = vertx;
        this.counter = new AtomicLong();
    }

    public AsynchronousCounter(VertxInternal vertx, AtomicLong counter) {
        this.vertx = vertx;
        this.counter = counter;
    }

    @Override
    public void get(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextInternal context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.get())));
    }

    @Override
    public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextInternal context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.incrementAndGet())));
    }

    @Override
    public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextInternal context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.getAndIncrement())));
    }

    @Override
    public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextInternal context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.decrementAndGet())));
    }

    @Override
    public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextInternal context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.addAndGet(value))));
    }

    @Override
    public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextInternal context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.getAndAdd(value))));
    }

    @Override
    public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextInternal context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.compareAndSet(expected, value))));
    }
}

