/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Context;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.Lock;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.impl.LockInternal;

public class LocalAsyncLocks {
    private final ConcurrentMap<String, List<LockWaiter>> waitersMap = new ConcurrentHashMap<String, List<LockWaiter>>();

    public void acquire(Context context, String name, long timeout, Handler<AsyncResult<Lock>> handler) {
        LockWaiter lockWaiter = new LockWaiter(context, name, timeout, handler);
        List waiters = this.waitersMap.compute(name, (s2, list) -> {
            ArrayList<LockWaiter> result;
            if (list != null) {
                result = new ArrayList(list.size() + 1);
                result.addAll((Collection<LockWaiter>)list);
            } else {
                result = new ArrayList<LockWaiter>(1);
            }
            result.add(lockWaiter);
            return result;
        });
        if (waiters.size() == 1) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
    }

    private void nextWaiter(String lockName) {
        List waiters = this.waitersMap.compute(lockName, (s2, list) -> list == null || list.size() == 1 ? null : new ArrayList(list.subList(1, list.size())));
        if (waiters != null) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
    }

    private class AsyncLock
    implements LockInternal {
        final String lockName;
        final AtomicBoolean invoked = new AtomicBoolean();

        AsyncLock(String lockName) {
            this.lockName = lockName;
        }

        @Override
        public void release() {
            if (this.invoked.compareAndSet(false, true)) {
                LocalAsyncLocks.this.nextWaiter(this.lockName);
            }
        }

        @Override
        public int waiters() {
            List waiters = (List)LocalAsyncLocks.this.waitersMap.get(this.lockName);
            return waiters == null ? 0 : waiters.size() - 1;
        }
    }

    private class LockWaiter {
        final Context context;
        final String lockName;
        final Handler<AsyncResult<Lock>> handler;
        final Long timerId;

        LockWaiter(Context context, String lockName, long timeout, Handler<AsyncResult<Lock>> handler) {
            this.context = context;
            this.lockName = lockName;
            this.handler = handler;
            this.timerId = timeout != Long.MAX_VALUE ? Long.valueOf(context.owner().setTimer(timeout, tid -> this.timeout())) : null;
        }

        void timeout() {
            LocalAsyncLocks.this.waitersMap.compute(this.lockName, (s2, list) -> {
                int idx;
                if (list == null || (idx = list.indexOf(this)) == -1) {
                    return list;
                }
                if (list.size() == 1) {
                    return null;
                }
                int size = list.size();
                ArrayList n = new ArrayList(size - 1);
                if (idx > 0) {
                    n.addAll(list.subList(0, idx));
                }
                if (idx + 1 < size) {
                    n.addAll(list.subList(idx + 1, size));
                }
                return n;
            });
            this.handler.handle(Future.failedFuture("Timed out waiting to get lock"));
        }

        void acquireLock() {
            if (this.timerId == null || this.context.owner().cancelTimer(this.timerId)) {
                if (this.timerId != null) {
                    this.context.owner().cancelTimer(this.timerId);
                }
                this.context.runOnContext(v -> this.handler.handle(Future.succeededFuture(new AsyncLock(this.lockName))));
            } else {
                this.context.runOnContext(v -> LocalAsyncLocks.this.nextWaiter(this.lockName));
            }
        }
    }
}

