/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.AsyncMap;

public class LocalAsyncMapImpl<K, V>
implements AsyncMap<K, V> {
    private final Vertx vertx;
    private final ConcurrentMap<K, Holder<V>> map;

    public LocalAsyncMapImpl(Vertx vertx) {
        this.vertx = vertx;
        this.map = new ConcurrentHashMap<K, Holder<V>>();
    }

    @Override
    public void get(K k, Handler<AsyncResult<V>> resultHandler) {
        Holder h2 = (Holder)this.map.get(k);
        if (h2 != null && h2.hasNotExpired()) {
            resultHandler.handle(Future.succeededFuture(h2.value));
        } else {
            resultHandler.handle(Future.succeededFuture());
        }
    }

    @Override
    public void put(K k, V v, Handler<AsyncResult<Void>> resultHandler) {
        Holder<V> previous = this.map.put(k, new Holder<V>(v));
        if (previous != null && previous.expires()) {
            this.vertx.cancelTimer(previous.timerId);
        }
        resultHandler.handle(Future.succeededFuture());
    }

    @Override
    public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        Holder<V> h2 = this.map.putIfAbsent(k, new Holder<V>(v));
        resultHandler.handle(Future.succeededFuture(h2 == null ? null : (Object)h2.value));
    }

    @Override
    public void put(K k, V v, long timeout, Handler<AsyncResult<Void>> completionHandler) {
        long timestamp = System.nanoTime();
        long timerId = this.vertx.setTimer(timeout, l -> this.removeIfExpired(k));
        Holder<V> previous = this.map.put(k, new Holder<V>(v, timerId, timeout, timestamp));
        if (previous != null && previous.expires()) {
            this.vertx.cancelTimer(previous.timerId);
        }
        completionHandler.handle(Future.succeededFuture());
    }

    private void removeIfExpired(K k) {
        this.map.computeIfPresent(k, (key, holder) -> holder.hasNotExpired() ? holder : null);
    }

    @Override
    public void putIfAbsent(K k, V v, long timeout, Handler<AsyncResult<V>> completionHandler) {
        long timestamp = System.nanoTime();
        long timerId = this.vertx.setTimer(timeout, l -> this.removeIfExpired(k));
        Holder<V> existing = this.map.putIfAbsent(k, new Holder<V>(v, timerId, timeout, timestamp));
        if (existing != null) {
            if (existing.expires()) {
                this.vertx.cancelTimer(timerId);
            }
            completionHandler.handle(Future.succeededFuture(existing.value));
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
    }

    @Override
    public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) {
        AtomicBoolean result = new AtomicBoolean();
        this.map.computeIfPresent(k, (key, holder) -> {
            if (holder.value.equals(v)) {
                result.compareAndSet(false, true);
                if (holder.expires()) {
                    this.vertx.cancelTimer(holder.timerId);
                }
                return null;
            }
            return holder;
        });
        resultHandler.handle(Future.succeededFuture(result.get()));
    }

    @Override
    public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        Holder<V> previous = this.map.replace(k, new Holder<V>(v));
        if (previous != null) {
            if (previous.expires()) {
                this.vertx.cancelTimer(previous.timerId);
            }
            resultHandler.handle(Future.succeededFuture(previous.value));
        } else {
            resultHandler.handle(Future.succeededFuture());
        }
    }

    @Override
    public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) {
        Holder<V> h2 = new Holder<V>(newValue);
        Holder result = this.map.computeIfPresent(k, (key, holder) -> {
            if (holder.value.equals(oldValue)) {
                if (holder.expires()) {
                    this.vertx.cancelTimer(holder.timerId);
                }
                return h2;
            }
            return holder;
        });
        resultHandler.handle(Future.succeededFuture(h2 == result));
    }

    @Override
    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.map.clear();
        resultHandler.handle(Future.succeededFuture());
    }

    @Override
    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        resultHandler.handle(Future.succeededFuture(this.map.size()));
    }

    @Override
    public void keys(Handler<AsyncResult<Set<K>>> resultHandler) {
        resultHandler.handle(Future.succeededFuture(new HashSet(this.map.keySet())));
    }

    @Override
    public void values(Handler<AsyncResult<List<V>>> asyncResultHandler) {
        List result = this.map.values().stream().filter(Holder::hasNotExpired).map(h2 -> h2.value).collect(Collectors.toList());
        asyncResultHandler.handle(Future.succeededFuture(result));
    }

    @Override
    public void entries(Handler<AsyncResult<Map<K, V>>> asyncResultHandler) {
        HashMap result = new HashMap(this.map.size());
        this.map.forEach((key, holder) -> {
            if (holder.hasNotExpired()) {
                result.put(key, holder.value);
            }
        });
        asyncResultHandler.handle(Future.succeededFuture(result));
    }

    @Override
    public void remove(K k, Handler<AsyncResult<V>> resultHandler) {
        Holder previous = (Holder)this.map.remove(k);
        if (previous != null) {
            if (previous.expires()) {
                this.vertx.cancelTimer(previous.timerId);
            }
            resultHandler.handle(Future.succeededFuture(previous.value));
        } else {
            resultHandler.handle(Future.succeededFuture());
        }
    }

    private static class Holder<V> {
        final V value;
        final long timerId;
        final long ttl;
        final long timestamp;

        Holder(V value) {
            Objects.requireNonNull(value);
            this.value = value;
            this.timerId = 0L;
            this.ttl = 0L;
            this.timestamp = 0L;
        }

        Holder(V value, long timerId, long ttl, long timestamp) {
            Objects.requireNonNull(value);
            if (ttl < 1L) {
                throw new IllegalArgumentException("ttl must be positive: " + ttl);
            }
            this.value = value;
            this.timerId = timerId;
            this.ttl = ttl;
            this.timestamp = timestamp;
        }

        boolean expires() {
            return this.ttl > 0L;
        }

        boolean hasNotExpired() {
            return !this.expires() || TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.timestamp, TimeUnit.NANOSECONDS) < this.ttl;
        }

        public String toString() {
            return "Holder{value=" + this.value + ", timerId=" + this.timerId + ", ttl=" + this.ttl + ", timestamp=" + this.timestamp + '}';
        }
    }
}

