/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.resolver;

import java.net.InetSocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.resolver.AddressResolverGroup;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.VertxException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.dns.AddressResolverOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.VertxImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.resolver.DefaultResolverProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.resolver.DnsResolverProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;

public interface ResolverProvider {
    public static final String DISABLE_DNS_RESOLVER_PROP_NAME = "vertx.disableDnsResolver";

    public static ResolverProvider factory(Vertx vertx, AddressResolverOptions options) {
        try {
            if (!Boolean.getBoolean(DISABLE_DNS_RESOLVER_PROP_NAME)) {
                return new DnsResolverProvider((VertxImpl)vertx, options);
            }
        }
        catch (Throwable e) {
            if (e instanceof VertxException) {
                throw e;
            }
            Logger logger = LoggerFactory.getLogger(ResolverProvider.class);
            logger.info("Using the default address resolver as the dns resolver could not be loaded");
        }
        return new DefaultResolverProvider();
    }

    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions var1);

    public void close(Handler<Void> var1);
}

