/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.DataObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.JWTOptionsConverter;

@DataObject(generateConverter=true)
public class JWTOptions {
    private static final JsonObject EMPTY = new JsonObject(Collections.emptyMap());
    private int leeway = 0;
    private boolean ignoreExpiration;
    private String algorithm = "HS256";
    private JsonObject header = EMPTY;
    private boolean noTimestamp;
    private int expiresInSeconds;
    private List<String> audience;
    private String issuer;
    private String subject;
    private List<String> permissions;

    public JWTOptions() {
    }

    public JWTOptions(JsonObject json) {
        JWTOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJSON() {
        JsonObject json = new JsonObject();
        JWTOptionsConverter.toJson(this, json);
        return json;
    }

    public int getLeeway() {
        return this.leeway;
    }

    public JWTOptions setLeeway(int leeway) {
        this.leeway = leeway;
        return this;
    }

    public boolean isIgnoreExpiration() {
        return this.ignoreExpiration;
    }

    public JWTOptions setIgnoreExpiration(boolean ignoreExpiration) {
        this.ignoreExpiration = ignoreExpiration;
        return this;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public JWTOptions setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public JsonObject getHeader() {
        return this.header;
    }

    public JWTOptions setHeader(JsonObject header) {
        this.header = header;
        return this;
    }

    public boolean isNoTimestamp() {
        return this.noTimestamp;
    }

    public JWTOptions setNoTimestamp(boolean noTimestamp) {
        this.noTimestamp = noTimestamp;
        return this;
    }

    public int getExpiresInSeconds() {
        return this.expiresInSeconds;
    }

    public JWTOptions setExpiresInSeconds(int expiresInSeconds) {
        this.expiresInSeconds = expiresInSeconds;
        return this;
    }

    public JWTOptions setExpiresInMinutes(int expiresInMinutes) {
        this.expiresInSeconds = expiresInMinutes * 60;
        return this;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public JWTOptions setAudience(List<String> audience) {
        this.audience = audience;
        return this;
    }

    public JWTOptions addAudience(String audience) {
        if (this.audience == null) {
            this.audience = new ArrayList<String>();
        }
        this.audience.add(audience);
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JWTOptions setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public JWTOptions setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public JWTOptions setPermissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public JWTOptions addPermission(String permission) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permission);
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }
}

