/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth;

import java.util.Base64;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.GenIgnore;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.VertxGen;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Context;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.PRNG;

@VertxGen
public interface VertxContextPRNG {
    public static VertxContextPRNG current() {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null) {
            return VertxContextPRNG.current(currentContext);
        }
        throw new IllegalStateException("Not running in a Vert.x Context.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GenIgnore
    public static VertxContextPRNG current(Context context) {
        String contextKey = "__vertx.VertxContextPRNG";
        PRNG random = (PRNG)context.get("__vertx.VertxContextPRNG");
        if (random == null) {
            Context context2 = context;
            synchronized (context2) {
                random = (PRNG)context.get("__vertx.VertxContextPRNG");
                if (random == null) {
                    PRNG rand = random = new PRNG(context.owner());
                    context.put("__vertx.VertxContextPRNG", rand);
                }
            }
        }
        return random;
    }

    public static VertxContextPRNG current(Vertx vertx) {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null) {
            return VertxContextPRNG.current(currentContext);
        }
        return new PRNG(vertx);
    }

    @GenIgnore
    public void nextBytes(byte[] var1);

    default public String nextString(int length) {
        byte[] data = new byte[length];
        this.nextBytes(data);
        return Base64.getMimeEncoder().encodeToString(data);
    }

    public int nextInt();

    public int nextInt(int var1);
}

