/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.impl;

import java.util.ArrayList;
import java.util.List;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.AuthProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.ChainAuth;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.User;

public class ChainAuthImpl
implements ChainAuth {
    private final List<AuthProvider> providers = new ArrayList<AuthProvider>();

    @Override
    public ChainAuth append(AuthProvider other) {
        this.providers.add(other);
        return this;
    }

    @Override
    public boolean remove(AuthProvider other) {
        return this.providers.remove(other);
    }

    @Override
    public void clear() {
        this.providers.clear();
    }

    @Override
    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.iterate(0, authInfo, resultHandler);
    }

    private void iterate(int idx, JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        if (idx >= this.providers.size()) {
            resultHandler.handle(Future.failedFuture("No more providers in the auth chain."));
            return;
        }
        this.providers.get(idx).authenticate(authInfo, res -> {
            if (res.succeeded()) {
                resultHandler.handle((AsyncResult<User>)res);
            } else {
                this.iterate(idx + 1, authInfo, resultHandler);
            }
        });
    }
}

