/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.impl;

import java.util.HashMap;
import java.util.Map;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.HashString;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.HashingAlgorithm;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.HashingStrategy;

public class HashingStrategyImpl
implements HashingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(HashingStrategyImpl.class);
    private final Map<String, HashingAlgorithm> algorithms = new HashMap<String, HashingAlgorithm>();

    public void add(HashingAlgorithm algorithm) {
        this.algorithms.put(algorithm.id(), algorithm);
    }

    @Override
    public String hash(String id, Map<String, String> params, String salt, String password) {
        HashingAlgorithm algorithm = this.algorithms.get(id);
        if (algorithm == null) {
            throw new RuntimeException(id + " algorithm is not available.");
        }
        String hash = algorithm.hash(new HashString(id, params, salt), password);
        return HashString.encode(algorithm, params, salt, hash);
    }

    @Override
    public boolean verify(String hash, String password) {
        if (hash == null || password == null) {
            return false;
        }
        HashString hashString = new HashString(hash);
        HashingAlgorithm algorithm = this.algorithms.get(hashString.id());
        if (algorithm == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No hash strategy for algorithm: " + hashString.id());
            }
            return false;
        }
        if (hashString.hash() == null) {
            return false;
        }
        String hasha = hashString.hash();
        String hashb = algorithm.hash(hashString, password);
        int diff = hasha.length() ^ hashb.length();
        for (int i = 0; i < hasha.length() && i < hashb.length(); ++i) {
            diff |= hasha.charAt(i) ^ hashb.charAt(i);
        }
        return diff == 0;
    }

    @Override
    public HashingAlgorithm get(String id) {
        return this.algorithms.get(id);
    }

    @Override
    public HashingStrategy put(String id, HashingAlgorithm algorithm) {
        if (this.algorithms.containsKey(id)) {
            LOG.warn("Existing algorithm: " + id + " will be replaced!");
        }
        this.algorithms.put(id, algorithm);
        return this;
    }
}

