/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.impl;

import java.io.File;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.UnpooledByteBufAllocator;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.DefaultFullHttpRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpConstants;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpContent;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpMethod;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.HttpVersion;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.multipart.MemoryFileUpload;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Context;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.MultiMap;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HeadersAdaptor;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.streams.ReadStream;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.streams.impl.InboundBuffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.multipart.FormDataPart;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.multipart.MultipartForm;

public class MultipartFormUpload
implements ReadStream<Buffer> {
    private static final UnpooledByteBufAllocator ALLOC = new UnpooledByteBufAllocator(false);
    private DefaultFullHttpRequest request;
    private HttpPostRequestEncoder encoder;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private InboundBuffer<Object> pending;
    private boolean ended;
    private final Context context;

    public MultipartFormUpload(Context context, MultipartForm parts, boolean multipart, HttpPostRequestEncoder.EncoderMode encoderMode) throws Exception {
        this.context = context;
        this.pending = new InboundBuffer<Object>(context).handler(this::handleChunk).drainHandler(v -> this.run()).pause();
        this.request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        this.encoder = new HttpPostRequestEncoder(new DefaultHttpDataFactory(16384L), this.request, multipart, HttpConstants.DEFAULT_CHARSET, encoderMode);
        for (FormDataPart formDataPart : parts) {
            if (formDataPart.isAttribute()) {
                this.encoder.addBodyAttribute(formDataPart.name(), formDataPart.value());
                continue;
            }
            String pathname = formDataPart.pathname();
            if (pathname != null) {
                this.encoder.addBodyFileUpload(formDataPart.name(), formDataPart.filename(), new File(formDataPart.pathname()), formDataPart.mediaType(), formDataPart.isText());
                continue;
            }
            String contentType = formDataPart.mediaType();
            if (formDataPart.mediaType() == null) {
                contentType = formDataPart.isText() != false ? "text/plain" : "application/octet-stream";
            }
            String transferEncoding = formDataPart.isText() != false ? null : "binary";
            MemoryFileUpload fileUpload = new MemoryFileUpload(formDataPart.name(), formDataPart.filename(), contentType, transferEncoding, null, formDataPart.content().length());
            fileUpload.setContent(formDataPart.content().getByteBuf());
            this.encoder.addBodyHttpData(fileUpload);
        }
        this.encoder.finalizeRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChunk(Object item) {
        Handler<Object> handler;
        MultipartFormUpload multipartFormUpload = this;
        synchronized (multipartFormUpload) {
            if (item instanceof Buffer) {
                handler = this.dataHandler;
            } else if (item instanceof Throwable) {
                handler = this.exceptionHandler;
            } else if (item == InboundBuffer.END_SENTINEL) {
                handler = this.endHandler;
                item = null;
            } else {
                return;
            }
        }
        handler.handle((Buffer)item);
    }

    public void run() {
        if (Vertx.currentContext() != this.context) {
            this.context.runOnContext(v -> this.run());
            return;
        }
        while (!this.ended) {
            if (this.encoder.isChunked()) {
                try {
                    HttpContent chunk = this.encoder.readChunk(ALLOC);
                    ByteBuf content = chunk.content();
                    Buffer buff = Buffer.buffer(content);
                    boolean writable = this.pending.write(buff);
                    if (this.encoder.isEndOfInput()) {
                        this.ended = true;
                        this.request = null;
                        this.encoder = null;
                        this.pending.write(InboundBuffer.END_SENTINEL);
                        continue;
                    }
                    if (writable) continue;
                }
                catch (Exception e) {
                    this.ended = true;
                    this.request = null;
                    this.encoder = null;
                    this.pending.write(e);
                }
                break;
            }
            ByteBuf content = this.request.content();
            Buffer buffer = Buffer.buffer(content);
            this.request = null;
            this.encoder = null;
            this.pending.write(buffer);
            this.ended = true;
            this.pending.write(InboundBuffer.END_SENTINEL);
        }
    }

    public MultiMap headers() {
        return new HeadersAdaptor(this.request.headers());
    }

    @Override
    public synchronized MultipartFormUpload exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized MultipartFormUpload handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    public synchronized MultipartFormUpload pause() {
        this.pending.pause();
        return this;
    }

    @Override
    public ReadStream<Buffer> fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    public synchronized MultipartFormUpload resume() {
        this.pending.resume();
        return this;
    }

    public synchronized MultipartFormUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

