/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.VertxException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpClient;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpMethod;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.RequestOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.impl.HttpClientImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.HttpRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.HttpResponse;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.WebClientOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.impl.HttpContext;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.impl.HttpRequestImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.impl.WebClientInternal;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.impl.predicate.PredicateInterceptor;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.codec.impl.BodyCodecImpl;

public class WebClientBase
implements WebClientInternal {
    final HttpClient client;
    final WebClientOptions options;
    private final List<Handler<HttpContext<?>>> interceptors;

    public WebClientBase(HttpClient client, WebClientOptions options) {
        this.client = client;
        this.options = new WebClientOptions(options);
        this.interceptors = new CopyOnWriteArrayList();
        this.addInterceptor(new PredicateInterceptor());
    }

    WebClientBase(WebClientBase webClient) {
        this.client = webClient.client;
        this.options = new WebClientOptions(webClient.options);
        this.interceptors = new CopyOnWriteArrayList(webClient.interceptors);
    }

    @Override
    public HttpRequest<Buffer> get(int port, String host, String requestURI) {
        return this.request(HttpMethod.GET, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> get(String requestURI) {
        return this.request(HttpMethod.GET, requestURI);
    }

    @Override
    public HttpRequest<Buffer> get(String host, String requestURI) {
        return this.request(HttpMethod.GET, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> getAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.GET, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> post(String requestURI) {
        return this.request(HttpMethod.POST, requestURI);
    }

    @Override
    public HttpRequest<Buffer> post(String host, String requestURI) {
        return this.request(HttpMethod.POST, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> post(int port, String host, String requestURI) {
        return this.request(HttpMethod.POST, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> put(String requestURI) {
        return this.request(HttpMethod.PUT, requestURI);
    }

    @Override
    public HttpRequest<Buffer> put(String host, String requestURI) {
        return this.request(HttpMethod.PUT, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> put(int port, String host, String requestURI) {
        return this.request(HttpMethod.PUT, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> delete(String host, String requestURI) {
        return this.request(HttpMethod.DELETE, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> delete(String requestURI) {
        return this.request(HttpMethod.DELETE, requestURI);
    }

    @Override
    public HttpRequest<Buffer> delete(int port, String host, String requestURI) {
        return this.request(HttpMethod.DELETE, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> patch(String requestURI) {
        return this.request(HttpMethod.PATCH, requestURI);
    }

    @Override
    public HttpRequest<Buffer> patch(String host, String requestURI) {
        return this.request(HttpMethod.PATCH, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> patch(int port, String host, String requestURI) {
        return this.request(HttpMethod.PATCH, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> head(String requestURI) {
        return this.request(HttpMethod.HEAD, requestURI);
    }

    @Override
    public HttpRequest<Buffer> head(String host, String requestURI) {
        return this.request(HttpMethod.HEAD, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> head(int port, String host, String requestURI) {
        return this.request(HttpMethod.HEAD, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> raw(String customHttpMethod, String requestURI) {
        return this.request(HttpMethod.OTHER, requestURI).rawMethod(customHttpMethod);
    }

    @Override
    public HttpRequest<Buffer> raw(String customHttpMethod, int port, String host, String requestURI) {
        return this.request(HttpMethod.OTHER, port, host, requestURI).rawMethod(customHttpMethod);
    }

    @Override
    public HttpRequest<Buffer> raw(String customHttpMethod, String host, String requestURI) {
        return this.request(HttpMethod.OTHER, host, requestURI).rawMethod(customHttpMethod);
    }

    @Override
    public HttpRequest<Buffer> postAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.POST, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> putAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> deleteAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> patchAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.PATCH, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> headAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> rawAbs(String customHttpMethod, String absoluteURI) {
        return this.requestAbs(HttpMethod.OTHER, absoluteURI).rawMethod(customHttpMethod);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, String requestURI) {
        return this.request(method, (SocketAddress)null, requestURI);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, String requestURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, this.options.isSsl(), this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, BodyCodecImpl.BUFFER, this.options);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, RequestOptions requestOptions) {
        return this.request(method, null, requestOptions);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, RequestOptions requestOptions) {
        HttpRequestImpl<Buffer> request = new HttpRequestImpl<Buffer>(this, method, serverAddress, requestOptions.isSsl(), requestOptions.getPort(), requestOptions.getHost(), requestOptions.getURI(), BodyCodecImpl.BUFFER, this.options);
        return requestOptions.getHeaders() == null ? request : request.putHeaders(requestOptions.getHeaders());
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, String host, String requestURI) {
        return this.request(method, null, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, String host, String requestURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, this.options.isSsl(), this.options.getDefaultPort(), host, requestURI, BodyCodecImpl.BUFFER, this.options);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, int port, String host, String requestURI) {
        return this.request(method, null, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, SocketAddress serverAddress, int port, String host, String requestURI) {
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, this.options.isSsl(), port, host, requestURI, BodyCodecImpl.BUFFER, this.options);
    }

    @Override
    public HttpRequest<Buffer> requestAbs(HttpMethod method, String surl) {
        return this.requestAbs(method, null, surl);
    }

    @Override
    public HttpRequest<Buffer> requestAbs(HttpMethod method, SocketAddress serverAddress, String surl) {
        URL url;
        try {
            url = new URL(surl);
        }
        catch (MalformedURLException e) {
            throw new VertxException("Invalid url: " + surl);
        }
        boolean ssl = false;
        int port = url.getPort();
        String protocol = url.getProtocol();
        if ("ftp".equals(protocol)) {
            if (port == -1) {
                port = 21;
            }
        } else {
            char chend = protocol.charAt(protocol.length() - 1);
            if (chend == 'p') {
                if (port == -1) {
                    port = 80;
                }
            } else if (chend == 's') {
                ssl = true;
                if (port == -1) {
                    port = 443;
                }
            }
        }
        return new HttpRequestImpl<Buffer>(this, method, serverAddress, protocol, ssl, port, url.getHost(), url.getFile(), BodyCodecImpl.BUFFER, this.options);
    }

    @Override
    public WebClientInternal addInterceptor(Handler<HttpContext<?>> interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    @Override
    public <T> HttpContext<T> createContext(Handler<AsyncResult<HttpResponse<T>>> handler) {
        HttpClientImpl client = (HttpClientImpl)this.client;
        return new HttpContext<T>(client.getVertx().getOrCreateContext(), client, this.interceptors, handler);
    }

    @Override
    public void close() {
        this.client.close();
    }
}

