/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.CaseInsensitiveHeaders;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.WebClient;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.WebClientSession;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.impl.SessionAwareInterceptor;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.impl.WebClientBase;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.client.spi.CookieStore;

public class WebClientSessionAware
extends WebClientBase
implements WebClientSession {
    private final CookieStore cookieStore;
    private CaseInsensitiveHeaders headers;

    public WebClientSessionAware(WebClient webClient, CookieStore cookieStore) {
        super((WebClientBase)webClient);
        this.cookieStore = cookieStore;
        this.addInterceptor(new SessionAwareInterceptor());
    }

    @Override
    public CookieStore cookieStore() {
        return this.cookieStore;
    }

    protected CaseInsensitiveHeaders headers() {
        if (this.headers == null) {
            this.headers = new CaseInsensitiveHeaders();
        }
        return this.headers;
    }

    @Override
    public WebClientSession addHeader(CharSequence name, CharSequence value) {
        this.headers().add(name, value);
        return this;
    }

    @Override
    public WebClientSession addHeader(String name, String value) {
        this.headers().add(name, value);
        return this;
    }

    @Override
    public WebClientSession addHeader(CharSequence name, Iterable<CharSequence> values) {
        this.headers().add(name, values);
        return this;
    }

    @Override
    public WebClientSession addHeader(String name, Iterable<String> values) {
        this.headers().add(name, values);
        return this;
    }

    @Override
    public WebClientSession removeHeader(CharSequence name) {
        this.headers().remove(name);
        return this;
    }

    @Override
    public WebClientSession removeHeader(String name) {
        this.headers().remove(name);
        return this;
    }
}

