/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.codec.impl;

import java.util.function.Function;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Promise;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.DecodeException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.json.JsonCodec;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.streams.WriteStream;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.codec.BodyCodec;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.codec.spi.BodyStream;

public class BodyCodecImpl<T>
implements BodyCodec<T> {
    public static final Function<Buffer, Void> VOID_DECODER = buff -> null;
    public static final Function<Buffer, String> UTF8_DECODER = Buffer::toString;
    public static final Function<Buffer, JsonObject> JSON_OBJECT_DECODER = buff -> {
        Object val = JsonCodec.INSTANCE.fromBuffer((Buffer)buff, Object.class);
        if (val == null) {
            return null;
        }
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        throw new DecodeException("Invalid Json Object decoded as " + val.getClass().getName());
    };
    public static final Function<Buffer, JsonArray> JSON_ARRAY_DECODER = buff -> {
        Object val = JsonCodec.INSTANCE.fromBuffer((Buffer)buff, Object.class);
        if (val == null) {
            return null;
        }
        if (val instanceof JsonArray) {
            return (JsonArray)val;
        }
        throw new DecodeException("Invalid Json Object decoded as " + val.getClass().getName());
    };
    public static final BodyCodec<String> STRING = new BodyCodecImpl<String>(UTF8_DECODER);
    public static final BodyCodec<Void> NONE = new BodyCodecImpl<Void>(VOID_DECODER);
    public static final BodyCodec<Buffer> BUFFER = new BodyCodecImpl<Buffer>(Function.identity());
    public static final BodyCodec<JsonObject> JSON_OBJECT = new BodyCodecImpl<JsonObject>(JSON_OBJECT_DECODER);
    public static final BodyCodec<JsonArray> JSON_ARRAY = new BodyCodecImpl<JsonArray>(JSON_ARRAY_DECODER);
    private final Function<Buffer, T> decoder;

    public static BodyCodecImpl<String> string(String encoding) {
        return new BodyCodecImpl<String>(buff -> buff.toString(encoding));
    }

    public static <T> BodyCodec<T> json(Class<T> type) {
        return new BodyCodecImpl<T>(BodyCodecImpl.jsonDecoder(type));
    }

    public static <T> Function<Buffer, T> jsonDecoder(Class<T> type) {
        return buff -> JsonCodec.INSTANCE.fromBuffer((Buffer)buff, type);
    }

    public BodyCodecImpl(Function<Buffer, T> decoder) {
        this.decoder = decoder;
    }

    @Override
    public void create(Handler<AsyncResult<BodyStream<T>>> handler) {
        handler.handle(Future.succeededFuture(new BodyStream<T>(){
            Buffer buffer = Buffer.buffer();
            Promise<T> state = Promise.promise();

            @Override
            public void handle(Throwable cause) {
                this.state.tryFail(cause);
            }

            @Override
            public Future<T> result() {
                return this.state.future();
            }

            @Override
            public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
                return this;
            }

            @Override
            public WriteStream<Buffer> write(Buffer data, Handler<AsyncResult<Void>> handler) {
                this.buffer.appendBuffer(data);
                handler.handle(Future.succeededFuture());
                return this;
            }

            @Override
            public WriteStream<Buffer> write(Buffer data) {
                this.buffer.appendBuffer(data);
                return this;
            }

            @Override
            public void end() {
                this.end((Handler<AsyncResult<Void>>)null);
            }

            @Override
            public void end(Handler<AsyncResult<Void>> handler) {
                if (!this.state.future().isComplete()) {
                    Object result;
                    if (this.buffer.length() > 0) {
                        try {
                            result = BodyCodecImpl.this.decoder.apply(this.buffer);
                        }
                        catch (Throwable t) {
                            this.state.fail(t);
                            if (handler != null) {
                                handler.handle(Future.failedFuture(t));
                            }
                            return;
                        }
                    } else {
                        result = null;
                    }
                    this.state.complete(result);
                    if (handler != null) {
                        handler.handle(Future.succeededFuture());
                    }
                }
            }

            @Override
            public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
                return this;
            }

            @Override
            public boolean writeQueueFull() {
                return false;
            }

            @Override
            public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
                return this;
            }
        }));
    }
}

