/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.common.template.impl;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class ConcurrentLRUCache<K, V>
extends ConcurrentHashMap<K, V> {
    private int maxSize;
    private final Queue<K> queue = new ArrayDeque<K>();

    public ConcurrentLRUCache(int maxSize) {
        this.maxSize = maxSize;
        this.checkSize();
    }

    public ConcurrentLRUCache(int initialCapacity, int maxSize) {
        super(initialCapacity);
        this.maxSize = maxSize;
        this.checkSize();
    }

    public ConcurrentLRUCache(Map<? extends K, ? extends V> m3, int maxSize) {
        super(m3);
        this.maxSize = maxSize;
        this.checkSize();
        for (K k : m3.keySet()) {
            this.entryAdded(k);
        }
        this.checkRemoveOldest();
    }

    public ConcurrentLRUCache(int initialCapacity, float loadFactor, int maxSize) {
        super(initialCapacity, loadFactor);
        this.maxSize = maxSize;
        this.checkSize();
    }

    public ConcurrentLRUCache(int initialCapacity, float loadFactor, int concurrencyLevel, int maxSize) {
        super(initialCapacity, loadFactor, concurrencyLevel);
        this.maxSize = maxSize;
        this.checkSize();
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.checkRemoveOldest();
    }

    @Override
    public V put(K key, V value) {
        V v = super.put(key, value);
        if (v == null) {
            this.entryAdded(key);
        }
        this.checkRemoveOldest();
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m3) {
        for (K k : m3.keySet()) {
            if (super.containsKey(k)) continue;
            this.entryAdded(k);
        }
        super.putAll(m3);
        this.checkRemoveOldest();
    }

    @Override
    public V remove(Object key) {
        Object v = super.remove(key);
        if (v != null) {
            this.entryRemoved(key);
        }
        return v;
    }

    @Override
    public void clear() {
        super.clear();
        this.queue.clear();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V v = super.putIfAbsent(key, value);
        if (v == null) {
            this.entryAdded(key);
        }
        this.checkRemoveOldest();
        return v;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = super.remove(key, value);
        if (removed) {
            this.entryRemoved(value);
        }
        return removed;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    private void entryAdded(K k) {
        this.queue.add(k);
    }

    private void entryRemoved(Object o) {
        if (!this.queue.remove(o)) {
            throw new IllegalStateException("Failed to remove");
        }
    }

    private void checkRemoveOldest() {
        while (this.queue.size() > this.maxSize) {
            K k = this.queue.poll();
            if (k == null) continue;
            super.remove(k);
        }
    }

    private void checkSize() {
        if (this.maxSize < 1) {
            throw new IllegalArgumentException("maxSize must be >= 1");
        }
    }

    public int queueSize() {
        return this.queue.size();
    }
}

