/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpHeaders;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.AuthProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.RoutingContext;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.impl.AuthHandlerImpl;

abstract class AuthorizationAuthHandler
extends AuthHandlerImpl {
    protected final Type type;

    AuthorizationAuthHandler(AuthProvider authProvider, Type type) {
        super(authProvider);
        this.type = type;
    }

    AuthorizationAuthHandler(AuthProvider authProvider, String realm, Type type) {
        super(authProvider, realm);
        this.type = type;
    }

    protected final void parseAuthorization(RoutingContext ctx, boolean optional, Handler<AsyncResult<String>> handler) {
        HttpServerRequest request = ctx.request();
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            if (optional) {
                handler.handle(Future.succeededFuture());
            } else {
                handler.handle(Future.failedFuture(UNAUTHORIZED));
            }
            return;
        }
        try {
            int idx = authorization.indexOf(32);
            if (idx <= 0) {
                handler.handle(Future.failedFuture(BAD_REQUEST));
                return;
            }
            if (!this.type.is(authorization.substring(0, idx))) {
                handler.handle(Future.failedFuture(UNAUTHORIZED));
                return;
            }
            handler.handle(Future.succeededFuture(authorization.substring(idx + 1)));
        }
        catch (RuntimeException e) {
            handler.handle(Future.failedFuture(e));
        }
    }

    static enum Type {
        BASIC("Basic"),
        DIGEST("Digest"),
        BEARER("Bearer"),
        HOBA("HOBA"),
        MUTUAL("Mutual"),
        NEGOTIATE("Negotiate"),
        OAUTH("OAuth"),
        SCRAM_SHA_1("SCRAM-SHA-1"),
        SCRAM_SHA_256("SCRAM-SHA-256");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public boolean is(String other) {
            return this.label.equalsIgnoreCase(other);
        }
    }
}

