/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.MultiMap;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpMethod;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpVersion;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.RoutingContext;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.LoggerFormat;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.LoggerHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.impl.Utils;

public class LoggerHandlerImpl
implements LoggerHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean immediate;
    private final LoggerFormat format;

    public LoggerHandlerImpl(boolean immediate, LoggerFormat format) {
        this.immediate = immediate;
        this.format = format;
    }

    public LoggerHandlerImpl(LoggerFormat format) {
        this(false, format);
    }

    private String getClientAddress(SocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.host();
    }

    private void log(RoutingContext context, long timestamp, String remoteClient, HttpVersion version, HttpMethod method, String uri) {
        HttpServerRequest request = context.request();
        long contentLength = 0L;
        if (this.immediate) {
            String obj = request.headers().get("content-length");
            if (obj != null) {
                try {
                    contentLength = Long.parseLong(obj.toString());
                }
                catch (NumberFormatException e) {
                    contentLength = 0L;
                }
            }
        } else {
            contentLength = request.response().bytesWritten();
        }
        String versionFormatted = "-";
        switch (version) {
            case HTTP_1_0: {
                versionFormatted = "HTTP/1.0";
                break;
            }
            case HTTP_1_1: {
                versionFormatted = "HTTP/1.1";
                break;
            }
            case HTTP_2: {
                versionFormatted = "HTTP/2.0";
            }
        }
        MultiMap headers = request.headers();
        int status = request.response().getStatusCode();
        String message = null;
        switch (this.format) {
            case DEFAULT: {
                String referrer = headers.contains("referrer") ? headers.get("referrer") : headers.get("referer");
                String userAgent = request.headers().get("user-agent");
                referrer = referrer == null ? "-" : referrer;
                userAgent = userAgent == null ? "-" : userAgent;
                message = String.format("%s - - [%s] \"%s %s %s\" %d %d \"%s\" \"%s\"", new Object[]{remoteClient, Utils.formatRFC1123DateTime(timestamp), method, uri, versionFormatted, status, contentLength, referrer, userAgent});
                break;
            }
            case SHORT: {
                message = String.format("%s - %s %s %s %d %d - %d ms", new Object[]{remoteClient, method, uri, versionFormatted, status, contentLength, System.currentTimeMillis() - timestamp});
                break;
            }
            case TINY: {
                message = String.format("%s %s %d %d - %d ms", new Object[]{method, uri, status, contentLength, System.currentTimeMillis() - timestamp});
            }
        }
        this.doLog(status, message);
    }

    protected void doLog(int status, String message) {
        if (status >= 500) {
            this.logger.error(message);
        } else if (status >= 400) {
            this.logger.warn(message);
        } else {
            this.logger.info(message);
        }
    }

    @Override
    public void handle(RoutingContext context) {
        long timestamp = System.currentTimeMillis();
        String remoteClient = this.getClientAddress(context.request().remoteAddress());
        HttpMethod method = context.request().method();
        String uri = context.request().uri();
        HttpVersion version = context.request().version();
        if (this.immediate) {
            this.log(context, timestamp, remoteClient, version, method, uri);
        } else {
            context.addBodyEndHandler(v -> this.log(context, timestamp, remoteClient, version, method, uri));
        }
        context.next();
    }
}

