/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.AuthProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.RoutingContext;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.Session;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.impl.AuthHandlerImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.impl.HttpStatusException;

public class RedirectAuthHandlerImpl
extends AuthHandlerImpl {
    private final String loginRedirectURL;
    private final String returnURLParam;

    public RedirectAuthHandlerImpl(AuthProvider authProvider, String loginRedirectURL, String returnURLParam) {
        super(authProvider);
        this.loginRedirectURL = loginRedirectURL;
        this.returnURLParam = returnURLParam;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        Session session = context.session();
        if (session != null) {
            session.put(this.returnURLParam, context.request().uri());
            handler.handle(Future.failedFuture(new HttpStatusException(302, this.loginRedirectURL)));
        } else {
            handler.handle(Future.failedFuture("No session - did you forget to include a SessionHandler?"));
        }
    }
}

