/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.impl;

import java.util.regex.Pattern;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.RoutingContext;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.VirtualHostHandler;

public class VirtualHostHandlerImpl
implements VirtualHostHandler {
    private final Pattern regex;
    private final Handler<RoutingContext> handler;

    public VirtualHostHandlerImpl(String hostname, Handler<RoutingContext> handler) {
        this.handler = handler;
        this.regex = Pattern.compile("^" + hostname.replaceAll("\\.", "\\\\.").replaceAll("[*]", "(.*?)") + "$", 2);
    }

    @Override
    public void handle(RoutingContext ctx) {
        String host = ctx.request().host();
        if (host == null) {
            ctx.next();
        } else {
            boolean match = false;
            for (String h2 : host.split(":")) {
                if (!this.regex.matcher(h2).matches()) continue;
                match = true;
                break;
            }
            if (match) {
                this.handler.handle(ctx);
            } else {
                ctx.next();
            }
        }
    }
}

