/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs;

import java.util.HashSet;
import java.util.Set;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.DataObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

@DataObject
public class SockJSHandlerOptions {
    public static final long DEFAULT_SESSION_TIMEOUT = 5000L;
    public static final boolean DEFAULT_INSERT_JSESSIONID = true;
    public static final long DEFAULT_HEARTBEAT_INTERVAL = 25000L;
    public static final int DEFAULT_MAX_BYTES_STREAMING = 131072;
    public static final String DEFAULT_LIBRARY_URL = "//cdn.jsdelivr.net/npm/sockjs-client@1/dist/sockjs.min.js";
    private long sessionTimeout;
    private boolean insertJSESSIONID;
    private long heartbeatInterval;
    private int maxBytesStreaming;
    private String libraryURL;
    private Set<String> disabledTransports = new HashSet<String>();

    public SockJSHandlerOptions(SockJSHandlerOptions other) {
        throw new UnsupportedOperationException("todo");
    }

    public SockJSHandlerOptions() {
        this.sessionTimeout = 5000L;
        this.insertJSESSIONID = true;
        this.heartbeatInterval = 25000L;
        this.maxBytesStreaming = 131072;
        this.libraryURL = DEFAULT_LIBRARY_URL;
    }

    public SockJSHandlerOptions(JsonObject json) {
        this.sessionTimeout = json.getLong("sessionTimeout", 5000L);
        this.insertJSESSIONID = json.getBoolean("insertJSESSIONID", true);
        this.heartbeatInterval = json.getLong("heartbeatInterval", 25000L);
        this.maxBytesStreaming = json.getInteger("maxBytesStreaming", 131072);
        this.libraryURL = json.getString("libraryURL", DEFAULT_LIBRARY_URL);
        JsonArray arr = json.getJsonArray("disabledTransports");
        if (arr != null) {
            for (Object str : arr) {
                if (str instanceof String) {
                    String sstr = (String)str;
                    this.disabledTransports.add(sstr);
                    continue;
                }
                throw new IllegalArgumentException("Invalid type " + str.getClass() + " in disabledTransports array");
            }
        }
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public SockJSHandlerOptions setSessionTimeout(long sessionTimeout) {
        if (sessionTimeout < 1L) {
            throw new IllegalArgumentException("sessionTimeout must be > 0");
        }
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public boolean isInsertJSESSIONID() {
        return this.insertJSESSIONID;
    }

    public SockJSHandlerOptions setInsertJSESSIONID(boolean insertJSESSIONID) {
        this.insertJSESSIONID = insertJSESSIONID;
        return this;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public SockJSHandlerOptions setHeartbeatInterval(long heartbeatInterval) {
        if (heartbeatInterval < 1L) {
            throw new IllegalArgumentException("heartbeatInterval must be > 0");
        }
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public int getMaxBytesStreaming() {
        return this.maxBytesStreaming;
    }

    public SockJSHandlerOptions setMaxBytesStreaming(int maxBytesStreaming) {
        if (maxBytesStreaming < 1) {
            throw new IllegalArgumentException("maxBytesStreaming must be > 0");
        }
        this.maxBytesStreaming = maxBytesStreaming;
        return this;
    }

    public String getLibraryURL() {
        return this.libraryURL;
    }

    public SockJSHandlerOptions setLibraryURL(String libraryURL) {
        this.libraryURL = libraryURL;
        return this;
    }

    public SockJSHandlerOptions addDisabledTransport(String subProtocol) {
        this.disabledTransports.add(subProtocol);
        return this;
    }

    public Set<String> getDisabledTransports() {
        return this.disabledTransports;
    }
}

