/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Promise;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.bridge.BridgeEventType;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.BridgeEvent;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.SockJSSocket;

class BridgeEventImpl
implements BridgeEvent {
    private final BridgeEventType type;
    private final JsonObject rawMessage;
    private final SockJSSocket socket;
    private final Promise<Boolean> promise;

    public BridgeEventImpl(BridgeEventType type, JsonObject rawMessage, SockJSSocket socket) {
        this.type = type;
        this.rawMessage = rawMessage;
        this.socket = socket;
        this.promise = Promise.promise();
    }

    @Override
    public Future<Boolean> future() {
        return this.promise.future();
    }

    @Override
    public BridgeEventType type() {
        return this.type;
    }

    @Override
    public JsonObject getRawMessage() {
        return this.rawMessage;
    }

    @Override
    public BridgeEvent setRawMessage(JsonObject message) {
        if (message != this.rawMessage) {
            this.rawMessage.clear().mergeIn(message);
        }
        return this;
    }

    @Override
    public void handle(AsyncResult<Boolean> asyncResult) {
        this.promise.handle(asyncResult);
    }

    @Override
    public SockJSSocket socket() {
        return this.socket;
    }

    @Override
    public void complete(Boolean result) {
        this.promise.complete(result);
    }

    @Override
    public void complete() {
        this.promise.complete();
    }

    @Override
    public void fail(Throwable throwable) {
        this.promise.fail(throwable);
    }

    @Override
    public void fail(String failureMessage) {
        this.promise.fail(failureMessage);
    }

    @Override
    public boolean tryComplete(Boolean result) {
        return this.promise.tryComplete(result);
    }

    @Override
    public boolean tryComplete() {
        return this.promise.tryComplete();
    }

    @Override
    public boolean tryFail(Throwable cause) {
        return this.promise.tryFail(cause);
    }

    @Override
    public boolean tryFail(String failureMessage) {
        return this.promise.tryFail(failureMessage);
    }
}

