/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl;

import java.util.regex.Pattern;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.LocalMap;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.Router;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.RoutingContext;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.SockJSSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl.SockJSSession;

class HtmlFileTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(HtmlFileTransport.class);
    private static final Pattern CALLBACK_VALIDATION = Pattern.compile("[^a-zA-Z0-9-_.]");
    private static final String HTML_FILE_TEMPLATE;

    HtmlFileTransport(Vertx vertx, Router router, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options);
        String htmlFileRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/htmlfile.*";
        router.getWithRegex(htmlFileRE).handler(rc -> {
            String callback;
            if (log.isTraceEnabled()) {
                log.trace("HtmlFile, get: " + rc.request().uri());
            }
            if ((callback = rc.request().getParam("callback")) == null && (callback = rc.request().getParam("c")) == null) {
                rc.response().setStatusCode(500).end("\"callback\" parameter required\n");
                return;
            }
            if (CALLBACK_VALIDATION.matcher(callback).find()) {
                rc.response().setStatusCode(500);
                rc.response().end("invalid \"callback\" parameter\n");
                return;
            }
            HttpServerRequest req = rc.request();
            String sessionID = req.params().get("param0");
            SockJSSession session = this.getSession((RoutingContext)rc, options.getSessionTimeout(), options.getHeartbeatInterval(), sessionID, sockHandler);
            session.register(req, new HtmlFileListener(options.getMaxBytesStreaming(), (RoutingContext)rc, callback, session));
        });
    }

    static {
        String str = "<!doctype html>\n<html><head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n</head><body><h2>Don't panic!</h2>\n  <script>\n    document.domain = document.domain;\n    var c = parent.{{ callback }};\n    c.start();\n    function p(d) {c.message(d);};\n    window.onload = function() {c.stop();};\n  </script>";
        String str2 = str.replace("{{ callback }}", "");
        StringBuilder sb = new StringBuilder(str);
        int extra = 1024 - str2.length();
        for (int i = 0; i < extra; ++i) {
            sb.append(' ');
        }
        sb.append("\r\n");
        HTML_FILE_TEMPLATE = sb.toString();
    }

    private class HtmlFileListener
    extends BaseTransport.BaseListener {
        final int maxBytesStreaming;
        final String callback;
        boolean headersWritten;
        int bytesSent;
        boolean closed;

        HtmlFileListener(int maxBytesStreaming, RoutingContext rc, String callback, SockJSSession session) {
            super(rc, session);
            this.maxBytesStreaming = maxBytesStreaming;
            this.callback = callback;
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            if (log.isTraceEnabled()) {
                log.trace("HtmlFile, sending frame");
            }
            if (!this.headersWritten) {
                String htmlFile = HTML_FILE_TEMPLATE.replace("{{ callback }}", this.callback);
                this.rc.response().putHeader("Content-Type", "text/html; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(this.rc);
                this.rc.response().setChunked(true);
                BaseTransport.setJSESSIONID(HtmlFileTransport.this.options, this.rc);
                this.rc.response().write(htmlFile);
                this.headersWritten = true;
            }
            body = HtmlFileTransport.this.escapeForJavaScript(body);
            String sb = "<script>\np(\"" + body + "\");\n</script>\r\n";
            Buffer buff = Buffer.buffer(sb);
            this.rc.response().write(buff, handler);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                if (log.isTraceEnabled()) {
                    log.trace("More than maxBytes sent so closing connection");
                }
                this.close();
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

